<?php

namespace MailerPressPro\Actions\ThirdParty\Divi;

use MailerPressPro\Core\Attributes\Action;
use MailerPressPro\Core\Kernel;
use function DI\value;

class Setup
{
    /**
     * Register MailerPress as an email provider for Divi Email Optin module
     * This needs to run very early, before et_core_get_third_party_components is called
     */
    #[Action('after_setup_theme', priority: 1)]
    public function registerEmailProvider()
    {
        // Add our filter to register MailerPress provider
        // This must run BEFORE the first call to et_core_get_third_party_components
        add_filter('et_core_get_third_party_components', [$this, 'addMailerPressProvider'], 10, 1);
    }

    /**
     * Add MailerPress to the list of email providers
     *
     * @param array $components Existing components
     * @param string $group Component group
     * @return array Modified components
     */
    public function addMailerPressProvider($group)
    {

        // Load the MailerPress provider class
        $provider_file = Kernel::$config['root'] . '/src/Services/ThirdParty/MailerPressDiviEmailProvider.php';

        if (!file_exists($provider_file)) {
            return $components;
        }

        if (!class_exists('MailerPressPro\Services\ThirdParty\MailerPressDiviEmailProvider')) {
            require_once $provider_file;
        }

        // Add MailerPress provider - key MUST be lowercase
        // Parameters: 'builder' (owner), 'default' (account name), '' (api key)
        $components['mailerpress'] = new \MailerPressPro\Services\ThirdParty\MailerPressDiviEmailProvider('builder', 'default', '');

        return $components;
    }
}
