<?php

namespace MailerPressPro\Actions;


use MailerPressPro\Core\Attributes\Filter;

class PluginRow
{
    #[Filter('plugin_action_links_mailerpress-pro/mailerpress-pro.php')]
    function plugin_row($actions)
    {
        $options = apply_filters('mailerpress_white_label_options', []);

        if (
            (isset($options['white_label_active']) && false === $options['white_label_active']) ||
            count($options) === 0
        ) {

            $actions[] = '<a href="https://mailerpress.com/support" target="_blank">' . __('Support', 'mailerpress-pro') . '</a>';

        }

        return $actions;
    }
}