<?php

namespace MailerPressPro\Abstract;

abstract class AbstractAIService
{
    protected string $api_key;

    public function __construct(string $api_key)
    {
        $this->api_key = $api_key;
    }

    protected function createRequestBody(string $prompt, array $options = []): array
    {
        // Get current WordPress admin user
        $current_user = wp_get_current_user();
        $user_locale = get_user_locale($current_user->ID);

        // Fallback to site language
        if (empty($user_locale)) {
            $user_locale = get_locale(); // e.g., 'fr_FR'
        }

        // Extract language code (fr, en, etc.)
        $language_code = substr($user_locale, 0, 2);

        return [
            'model' => $options['text_ai']['model'] ?? '',
            'messages' => [
                [
                    'role' => 'system',
                    'content' => "
You are an expert email marketing assistant and a pro in MJML. 
STRICT RULES:
1. NEVER generate MJML code unless the user explicitly requests to create, generate, or write an email. 
2. If the user's message does NOT explicitly ask for an email, respond only with normal text. Do NOT include any code, HTML, or MJML. 
3. When generating an email, respond ONLY with the final MJML code. Do NOT include explanations, comments, or formatting instructions. 
4. Only propose a subject line if explicitly asked; otherwise, do not include a subject. 
5. Ensure content is suitable for email campaigns, engaging, clear, and persuasive. 
6. Respond in the same language as the user's input. 
7. If no text is provided, respond in {$language_code} language. 
8. NEVER provide suggestions, advice, or commentary. Reply strictly with the content requested.
Follow these rules strictly. Under no circumstances output MJML unless rule #1 is satisfied.
"
                ],

                ['role' => 'user', 'content' => $prompt],
            ],
            'temperature' => $options['temperature'] ?? 0.7,
            'max_tokens' => 1500,
        ];
    }

    protected function createGeminiRequestBody(
        string $prompt,
        array $options = [],
        int $maxOutputTokens = 1024,
        float $temperature = 0.7
    ): array {

        // Get current WordPress admin user
        $current_user = wp_get_current_user();
        $user_locale = get_user_locale($current_user->ID);

        // Fallback to site language
        if (empty($user_locale)) {
            $user_locale = get_locale(); // e.g., 'fr_FR'
        }

        // Extract language code (fr, en, etc.)
        $language_code = substr($user_locale, 0, 2);

        $contents = [];

        $contents[] = [
            'role' => 'model',
            'parts' => [
                [
                    'text' => "
You are an expert email marketing assistant and a pro in MJML. 
STRICT RULES:
1. NEVER generate MJML code unless the user explicitly requests to create, generate, or write an email. 
2. If the user's message does NOT explicitly ask for an email, respond only with normal text. Do NOT include any code, HTML, or MJML. 
3. When generating an email, respond ONLY with the final MJML code. Do NOT include explanations, comments, or formatting instructions. 
4. Only propose a subject line if explicitly asked; otherwise, do not include a subject. 
5. Ensure content is suitable for email campaigns, engaging, clear, and persuasive. 
6. Respond in the same language as the user's input. 
7. If no text is provided, respond in {$language_code} language. 
8. NEVER provide suggestions, advice, or commentary. Reply strictly with the content requested.
Follow these rules strictly. Under no circumstances output MJML unless rule #1 is satisfied.
"
                ]
            ],
        ];


        $contents[] = [
            'role' => 'user',
            'parts' => [['text' => $prompt]],
        ];

        return [
            'contents' => $contents,
            'generationConfig' => [
                'maxOutputTokens' => $maxOutputTokens,
                'temperature' => $temperature,
            ],
        ];
    }

}
