<?php
/**
 * Global functions of plugin.
 *
 * @link       https://wpswings.com/
 * @since      1.0.0
 *
 * @package    Crm_Integration_For_Zoho
 * @subpackage Crm_Integration_For_Zoho/woo-includes
 */
use Automattic\WooCommerce\Internal\DataStores\Orders\CustomOrdersTableController;
use Automattic\WooCommerce\Utilities\OrderUtil;

/**
 * Execute wpdb query.
 *
 * @param  string $query Query to be executed.
 */
function mwb_woo_keap_execute_db_query( $query ) {
	global $wpdb;
	$wpdb->query( $query ); // @codingStandardsIgnoreLine.
}

/**
 * Get keap log data from database.
 *
 * @param  string|boolean $search_value Search value.
 * @param  integer        $limit        Max limit of data.
 * @param  integer        $offset       Offest to start.
 * @param  boolean        $all          Return all results.
 * @return array                        Array of data.
 */
function mwb_woo_keap_get_log_data( $search_value = false, $limit = 25, $offset = 0, $all = false ) {

	global $wpdb;
	$table_name = $wpdb->prefix . 'mwb_woo_keap_log';

	$log_data = array();

	if ( $all ) {

		$log_data = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM {$table_name} ORDER BY `id` DESC" ), ARRAY_A ); // @codingStandardsIgnoreLine.
		return $log_data;

	}

	if ( ! $search_value ) {

		$log_data    = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM {$table_name} ORDER BY `id` DESC LIMIT %d OFFSET %d ", $limit, $offset ), ARRAY_A ); // @codingStandardsIgnoreLine.
		return $log_data;

	}

	if ( is_string( $search_value ) ) {
		if ( '--Select Keap Object--' != $search_value ) {
			$log_data    = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM {$table_name} WHERE `keap_object` = %s ", $search_value ), ARRAY_A ); // @codingStandardsIgnoreLine.
		} else {
			$log_data = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM {$table_name} ORDER BY `id` DESC" ), ARRAY_A ); // @codingStandardsIgnoreLine.
		}
	} else {
		$log_data    = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM {$table_name} WHERE `woo_id` = %d ", $search_value ), ARRAY_A ); // @codingStandardsIgnoreLine.
	}
	
	return $log_data;
}

/**
 * Get total count from log table.
 *
 * @return integer Total count.
 */
function mwb_woo_keap_get_total_log_count() {
	global $wpdb;
	$table_name = $wpdb->prefix . 'mwb_woo_keap_log';
	$count = $wpdb->get_col( "SELECT COUNT(*) as `total_count` FROM {$table_name}" ); // @codingStandardsIgnoreLine.
	return $count;
}

/**
 * Get query results from database
 *
 * @param  string $query Query to be executed.
 * @return array         Result data.
 */
function mwb_woo_keap_get_query_results( $query ) {
	global $wpdb;
	$result = $wpdb->get_results( $query, ARRAY_A ); // @codingStandardsIgnoreLine.
	return $result;
}
/**
 * Get total count from log table.
 *
 * @return integer Total count.
 */
function mwb_woo_keap_get_total_shop_order_count() {

	global $wpdb;

	$table_name = $wpdb->prefix . 'posts';

	$sql      = "SELECT COUNT(`ID`) FROM {$table_name} WHERE ( `post_type` = 'shop_order' )";
	$log_data = $wpdb->get_results($sql, ARRAY_A ); // @codingStandardsIgnoreLine.

	foreach ( $log_data as $key => $value ) {
		$count = $value['COUNT(`ID`)'];
		break;
	}

	return is_numeric( $count ) ? $count : 0;
}

/**
 * Get total count from log table.
 *
 * @return integer Total count.
 */
function mwb_woo_keap_get_total_product_count() {

	global $wpdb;

	$table_name = $wpdb->prefix . 'posts';

	$sql      = "SELECT COUNT(`ID`) FROM {$table_name} WHERE ( `post_type` = 'product' )";
	$log_data = $wpdb->get_results($sql, ARRAY_A ); // @codingStandardsIgnoreLine.
	foreach ( $log_data as $key => $value ) {
		$count = $value['COUNT(`ID`)'];
		break;
	}

	return is_numeric( $count ) ? $count : 0;
}

/**
 * Undocumented function
 *
 * @param boolean $option_name
 * @param boolean $def_value
 * @return string
 */
function wps_get_object_type( $object_id ) {
	if ( wc_get_container()-> get(CustomOrdersTableController::class)-> custom_orders_table_usage_is_enabled() ) {
		$post_type = empty ( OrderUtil::get_order_type( $object_id ) ) ? get_post_type( $object_id ) : OrderUtil::get_order_type( $object_id ) ;
	} else {
		$post_type = get_post_type( $object_id );
	}
	return $post_type;
}

function wps_get_cot_enabled_order_enabled() {
	$is_enabled = wc_get_container()-> get(CustomOrdersTableController::class)-> custom_orders_table_usage_is_enabled() ?  true :  false;
	return $is_enabled;
}