<?php
/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://wpswings.com/
 * @since      1.0.0
 *
 * @package    Integration_With_keap
 * @subpackage Integration_With_keap/includes
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Integration_With_keap
 * @subpackage Integration_With_keap/includes
 */
use Automattic\WooCommerce\Utilities\OrderUtil;
class Crm_Integration_Request_Module_Keap {

	/**
	 *  The instance of this class.
	 *
	 * @since  1.0.0
	 * @var    string    $_instance    The instance of this class.
	 */
	private static $_instance;

	/**
	 *  The instance of this class.
	 *
	 * @since  1.0.0
	 * @var    string    $feed id to record  The feed to sync.
	 */
	public static $feed_id;

	/**
	 *  The instance of this class.
	 *
	 * @since  1.0.0
	 * @var    string    $crm_connect_manager to record  The feed to sync.
	 */
	public $crm_connect_manager;

	/**
	 *  The instance of this class.
	 *
	 * @since  1.0.0
	 * @var    string    $form_fields to record  The feed to sync.
	 */
	public $form_fields;

	/**
	 * Main Crm_Integration_Request_Module_Keap Instance.
	 *
	 * Ensures only one instance of Crm_Integration_Request_Module_Keap is loaded.
	 *
	 * @since 1.0.0
	 * @static
	 * @return Crm_Integration_Request_Module_Keap - Main instance.
	 */
	public static function get_instance() {

		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}

		return self::$_instance;
	}

	/**
	 * Main Crm_Integration_Request_Module_Keap Instance.
	 *
	 * Ensures only one instance of Crm_Integration_Request_Module_Keap is loaded.
	 *
	 * @since  1.0.0
	 */
	public function __construct() {
		$this->crm_connect_manager = Woo_Crm_Connect_Keap::get_instance();
	}

	/**
	 * If instant sync is required.
	 *
	 * @since  1.0.0
	 * @return string|array  Feeds ids.
	 */
	public static function isInstantSyncRequired() {
		// Get Keap Instance.
		$keap = Woo_Crm_Connect_Keap::get_instance();

		$current_function = function_exists( 'debug_backtrace' ) &&
		! empty( debug_backtrace()[1]['function'] ) ?
		debug_backtrace()[1]['function'] :
		'';

		if ( ! empty( $current_function ) ) {
			$args = array(
				'hook'      => current_action(),
				'callback'  => $current_function,
			);

		} else {

			// Get from WP filter.
			global $wp_filter;
			if ( ! empty( ! empty( $wp_filter[ current_action() ]->callbacks ) ) ) {
				$callbacks = $wp_filter[ current_action() ]->callbacks;
				foreach ( $callbacks as $key => $_callback ) {
					$function = ! empty( $_callback ) ?
					$_callback :
					array();

					foreach ( $_callback  as $key => $function ) {
						if ( false !== strpos( json_encode( $function ), 'crm_connect_manager' ) ) {
							foreach ( $function as $key => $func ) {
								$current_function = ! empty( $func[1] )
								? $func[1] :
								false;
								break;
							}
						}
					}
				}
			}

			$args = array(
				'hook'      => current_action(),
				'callback'  => $current_function,
				'params'    => $keap->getHookParamCount( current_action() ),
			);
		}

		// Get all probable Feeds callbacks.
		$hookable_callbacks = $keap->getHookRequestsForFeed();

		$feed_id = self::getFeedIdByRequest( $args );

		if ( ! empty( $feed_id ) && is_array( $feed_id ) ) {

			if ( 1 == count( $feed_id ) ) {

				$event = $keap->getFeed( $feed_id[0], 'feed_event' );
				// Check if sync is need to be instantly synced or not.
				if ( 'send_manually' == $event ) {
					if ( isset( $_POST['meta_box_nonce'] ) ) {
						if ( wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['meta_box_nonce'] ) ), 'meta_box_nonce' ) ) {
							$maybe_perform_manual_sync = is_admin() && ! empty( $_POST['mwb_manual_sync'] )
							&& true == $_POST['mwb_manual_sync'] ? true : false; //phpcs:ignore
							if ( true == $maybe_perform_manual_sync ) { //phpcs:ignore
								return $feed_id[0];
							} else {
								return false;
							}
						}
					}
				} else {
					return $feed_id[0];
				}
			} else {

				foreach ( $feed_id as $key => $f_id ) {
					$event = $keap->getFeed( $f_id, 'feed_event' );
					// Check if sync is need to be instantly synced or not.
					if ( 'send_manually' == $event ) {
						if ( isset( $_POST['meta_box_nonce'] ) ) {
							if ( wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['meta_box_nonce'] ) ), 'meta_box_nonce' ) ) {
								$maybe_perform_manual_sync = is_admin() && ! empty( $_POST['mwb_manual_sync'] )
								&& true == $_POST['mwb_manual_sync'] ? true : false; //phpcs:ignore
								if ( false == $maybe_perform_manual_sync ) { //phpcs:ignore
									unset( $feed_id[ $key ] );
								}
							}
						}
					}
				}

				return $feed_id;
			}
		} else {
			return false;
		}
	}

	/**
	 * If Feed id is not justified due to multiple hooks.
	 *
	 * @param array $args The args for hook and callback.
	 *
	 * @since  1.0.0
	 * @return bool  true|false.
	 */
	public static function getFeedIdByRequest( $args = array() ) {

		// Get Keap Instance.
		$keap = Woo_Crm_Connect_Keap::get_instance();
		$hookable_callbacks = $keap->getHookRequestsForFeed();

		if ( empty( $hookable_callbacks ) ) {
			return;
		}

		if ( empty( $args ) ) {
			$hooks = array(
				'woocommerce_order_status_pending',
				'woocommerce_order_status_failed',
				'woocommerce_order_fully_refunded',
				'woocommerce_order_partially_refunded',
				'woocommerce_order_status_cancelled',
				'woocommerce_order_status_completed',
				'woocommerce_order_status_on-hold',
				'woocommerce_order_status_processing',
			);

			$args = array(
				'hook'      => $hooks,
				'callback'  => 'shopOrderStatusChanged',
			);
		}

		$feed_ids = array();
		foreach ( $hookable_callbacks as $feed_id => $feed_args ) {

			if ( $feed_args == $args ) {

				if ( ! empty( $feed_id ) ) {
					$feed_ids[] = $feed_id;
				}
			}
		}

		return $feed_ids;
	}

	/**
	 * Prepare/Fire a request whenever a product is created/updated.
	 *
	 * This hooks works only for admin side create/update.
	 *
	 * @param string $post_id Woo Object post ID.
	 * @param string $post    Woo Object post.
	 * @param string $update  Woo Object is updated or not.
	 *
	 * @since  1.0.0
	 * @return null
	 */
	public function createAndUpdateProduct( $post_id, $post, $update = array(), $feed_id = '' ) {
		$crm_connect_manager = new Woo_Crm_Connect_Keap();
		// Return if doing autosave.
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return;
		}

		// Return if doing ajax :: Quick edits.
		if ( defined( 'DOING_AJAX' ) && DOING_AJAX ) {
			return;
		}

		if ( ! isset( $_POST['meta_box_nonce'] ) ) {
			return;
		}

		if ( ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['meta_box_nonce'] ) ), 'meta_box_nonce' ) ) {
			return;
		}

		// Return on post trash, quick-edit, new post.
		if ( empty( $_POST['action'] ) || 'editpost' != $_POST['action'] ) {
			return;
		}

		$feed_id = empty( $feed_id ) ? self::isInstantSyncRequired() : false;

		if ( ! empty( $feed_id ) && is_numeric( $feed_id ) ) {

			$keap = Woo_Crm_Connect_Keap::get_instance();
			$feed_title = $keap->getFeedTitle( $feed_id );
			$record_type = $keap->getFeed( $feed_id, 'crm_object' );
			// Get product.
			$product = wc_get_product( $post_id );
			$bulk_request = array();

			if ( 'variable' == $product->get_type() ) {
				$available_variations = $product->get_available_variations();
				if ( ! empty( $available_variations ) && is_array( $available_variations ) ) {

					$bulk_ids = array();
					foreach ( $available_variations as $key => $variation ) {
						$request = $crm_connect_manager->getRequest(
							$post->post_type,
							$feed_id,
							$variation['variation_id']
						);

						$bulk_ids[] = $variation['variation_id'];

					   /**
						* Keap product request filter hook.
						*
						* @since    1.0.0
						*/
						$request = apply_filters(
							'woo_crm_woo_keap_product_request',
							$request,
							$post_id
						);

						$request['product_id'] = $variation['variation_id'];
						array_push( $bulk_request, $request );
					}

				}
			} else {
				$request = $crm_connect_manager->getRequest(
					$post->post_type,
					$feed_id,
					$post_id
				);
				$bulk_ids[] = $post_id;

			   /**
				* Keap product request filter hook.
				*
				* @since    1.0.0
				*/
				$request = apply_filters(
					'woo_crm_woo_keap_product_request',
					$request,
					$post_id
				);
				$request['product_id'] = $post_id;
			}
			$request['active'] = 'true';
			$request['subscription_only'] = 'false';
			$request = ! empty( $bulk_request ) ?
			$bulk_request :
			$request;
			
			$record_type = $crm_connect_manager->getFeed(
				$feed_id,
				'crm_object'
			);

			$feed_title = $keap->getFeedTitle( $feed_id );

			$log_data = array(
				'woo_id'   => $post_id,
				'bulk_ids'   => $bulk_ids,
				'feed_id'  => $feed_id,
				'woo_object' => $post->post_type,
				'feed_title' => $feed_title,
			);

			$filter_exist = $this->maybe_check_filter( $feed_id );
			if ( ( isset( $filter_exist[2] ) && ! empty( $filter_exist[2][1]['field'] ) && '-1' != $filter_exist[2][1]['field'] ) || ( isset( $filter_exist[1] ) && ! empty( $filter_exist[1][1]['field'] ) && '-1' != $filter_exist[1][1]['field'] ) || ( isset( $filter_exist[3] ) && ! empty( $filter_exist[3][1]['field'] ) && '-1' != $filter_exist[3][1]['field'] ) || ( isset( $filter_exist[4] ) && ! empty( $filter_exist[4][1]['field'] ) && '-1' != $filter_exist[4][1]['field'] ) ) {
				$filter_result = $this->wps_validate_filter( $filter_exist, $request );
				if ( true === $filter_result ) {
					$crm_integration_keap_api = Crm_Integration_Keap_Api::get_instance();
					if ( is_array( $request) && array_key_exists(0, $request) ) {
		
						foreach ($request as $key => $single_request) {
							
							$woo_id = $single_request['product_id'];
		
							$update_prod_id = get_post_meta( $woo_id, '_mwb_keap_product_id', true );
		
							foreach ( $single_request as $k => $v ) {
		
								if ( 'product_id' !== $k ) {
		
									$single_record[ $k ] = $v;
								}
							}
							if ( ! empty( $update_prod_id ) ) {
		
								$endpoint = 'https://api.infusionsoft.com/crm/rest/v1/products/' . $update_prod_id;
								$request_data = json_encode( $single_record );
		
								$result = $crm_integration_keap_api->update_single_products(
									$record_type,
									$request_data,
									$endpoint,
									$woo_id,
									! empty( $bulk_request ) ? true : false,
									$log_data
								);
								if (! empty( $result['data']['id'])) {
		
									$keap_id = $result['data']['id'];
								}
								$is_success = Crm_Integration_For_Keap_Admin::is_success_res( $result );
		
								Crm_Integration_For_Keap_Admin::set_woo_response_meta_for_count( $feed_id, $woo_id, $keap_id, $is_success );
		
								
							} else {
								$request_data = json_encode( $single_record );
		
								$endpoint = 'https://api.infusionsoft.com/crm/rest/v1/products/';
								$result = $crm_integration_keap_api->create_single_record(
									$record_type,
									$request_data,
									! empty( $bulk_request ) ? true : false,
									$log_data,
									$endpoint,
									$woo_id
								);
		
								if ( 'Products' == $record_type ) {
									if (! empty( $result['data']['id'])) {
		
										$keap_id = $result['data']['id'];
									}
									update_post_meta( $single_request['product_id'], '_mwb_keap_product_id', $keap_id );
		
									$is_success = Crm_Integration_For_Keap_Admin::is_success_res( $result );
		
									Crm_Integration_For_Keap_Admin::set_woo_response_meta_for_count( $feed_id, $woo_id, $keap_id, $is_success );
		
								}
							}
						}
					} else {
		
						$woo_id = $request['product_id'];
		
						$update_prod_id = get_post_meta( $request['product_id'], '_mwb_keap_product_id', true );
		
						foreach ( $request as $k => $v ) {
		
							if ( 'product_id' !== $k ) {
		
								$single_record[ $k ] = $v;
							}
						}
						
						if ( ! empty( $update_prod_id ) ) {
		
							$endpoint = 'https://api.infusionsoft.com/crm/rest/v1/products/' . $update_prod_id;
		
							$request_data = json_encode( $single_record );
		
							$result = $crm_integration_keap_api->update_single_products(
								$record_type,
								$request_data,
								$endpoint,
								$woo_id,
								! empty( $bulk_request ) ? true : false,
								$log_data
							);
							if (! empty( $result['data']['id'])) {
		
								$keap_id = $result['data']['id'];
							}
							$is_success = Crm_Integration_For_Keap_Admin::is_success_res( $result );
		
							Crm_Integration_For_Keap_Admin::set_woo_response_meta_for_count( $feed_id, $woo_id, $keap_id, $is_success );
		
						} else {
		
							$request_data = json_encode( $single_record );
		
							$endpoint = 'https://api.infusionsoft.com/crm/rest/v1/products/';
							$result = $crm_integration_keap_api->create_single_record(
								$record_type,
								$request_data,
								! empty( $bulk_request ) ? true : false,
								$log_data,
								$endpoint,
								$woo_id
							);
		
							if ( 'Products' == $record_type ) {
								if (! empty( $result['data']['id'])) {
		
									$keap_id = $result['data']['id'];
								}
								update_post_meta( $request['product_id'], '_mwb_keap_product_id', $keap_id );
		
								$is_success = Crm_Integration_For_Keap_Admin::is_success_res( $result );
		
								Crm_Integration_For_Keap_Admin::set_woo_response_meta_for_count( $feed_id, $woo_id, $keap_id, $is_success );
		
							}
						}
					}
				}
			} else {
				$crm_integration_keap_api = Crm_Integration_Keap_Api::get_instance();
				if ( is_array( $request) && array_key_exists(0, $request) ) {

					foreach ($request as $key => $single_request) {
						
						$woo_id = $single_request['product_id'];

						$update_prod_id = get_post_meta( $woo_id, '_mwb_keap_product_id', true );

						foreach ( $single_request as $k => $v ) {

							if ( 'product_id' !== $k ) {

								$single_record[ $k ] = $v;
							}
						}
						if ( ! empty( $update_prod_id ) ) {

							$endpoint = 'https://api.infusionsoft.com/crm/rest/v1/products/' . $update_prod_id;
							$request_data = json_encode( $single_record );

							$result = $crm_integration_keap_api->update_single_products(
								$record_type,
								$request_data,
								$endpoint,
								$woo_id,
								! empty( $bulk_request ) ? true : false,
								$log_data
							);
							if (! empty( $result['data']['id'])) {

								$keap_id = $result['data']['id'];
							}
							$is_success = Crm_Integration_For_Keap_Admin::is_success_res( $result );

							Crm_Integration_For_Keap_Admin::set_woo_response_meta_for_count( $feed_id, $woo_id, $keap_id, $is_success );

							
						} else {
							$request_data = json_encode( $single_record );

							$endpoint = 'https://api.infusionsoft.com/crm/rest/v1/products/';
							$result = $crm_integration_keap_api->create_single_record(
								$record_type,
								$request_data,
								! empty( $bulk_request ) ? true : false,
								$log_data,
								$endpoint,
								$woo_id
							);

							if ( 'Products' == $record_type ) {
								if (! empty( $result['data']['id'])) {

									$keap_id = $result['data']['id'];
								}
								update_post_meta( $single_request['product_id'], '_mwb_keap_product_id', $keap_id );

								$is_success = Crm_Integration_For_Keap_Admin::is_success_res( $result );

								Crm_Integration_For_Keap_Admin::set_woo_response_meta_for_count( $feed_id, $woo_id, $keap_id, $is_success );

							}
						}
					}
				} else {

					$woo_id = $request['product_id'];

					$update_prod_id = get_post_meta( $request['product_id'], '_mwb_keap_product_id', true );

					foreach ( $request as $k => $v ) {

						if ( 'product_id' !== $k ) {

							$single_record[ $k ] = $v;
						}
					}
					
					if ( ! empty( $update_prod_id ) ) {

						$endpoint = 'https://api.infusionsoft.com/crm/rest/v1/products/' . $update_prod_id;

						$request_data = json_encode( $single_record );

						$result = $crm_integration_keap_api->update_single_products(
							$record_type,
							$request_data,
							$endpoint,
							$woo_id,
							! empty( $bulk_request ) ? true : false,
							$log_data
						);
						if (! empty( $result['data']['id'])) {

							$keap_id = $result['data']['id'];
						}
						$is_success = Crm_Integration_For_Keap_Admin::is_success_res( $result );

						Crm_Integration_For_Keap_Admin::set_woo_response_meta_for_count( $feed_id, $woo_id, $keap_id, $is_success );

					} else {

						$request_data = json_encode( $single_record );

						$endpoint = 'https://api.infusionsoft.com/crm/rest/v1/products/';
						$result = $crm_integration_keap_api->create_single_record(
							$record_type,
							$request_data,
							! empty( $bulk_request ) ? true : false,
							$log_data,
							$endpoint,
							$woo_id
						);

						if ( 'Products' == $record_type ) {
							if (! empty( $result['data']['id'])) {

								$keap_id = $result['data']['id'];
							}
							update_post_meta( $request['product_id'], '_mwb_keap_product_id', $keap_id );

							$is_success = Crm_Integration_For_Keap_Admin::is_success_res( $result );

							Crm_Integration_For_Keap_Admin::set_woo_response_meta_for_count( $feed_id, $woo_id, $keap_id, $is_success );

						}
					}
				}
			}
		}
	}


	/**
	 * Prepare/Fire a request whenever a shop order is manually synced.
	 *
	 * This hooks works only for admin side create/update.
	 *
	 * @param string $post_id Woo Object post ID.
	 * @param string $post    Woo Object post.
	 * @param string $update  Woo Object is updated or not.
	 *
	 * @since  1.0.0
	 * @return null
	 */
	public function createAndUpdateShopOrder( $post_id, $post, $update ) {

		// Return if doing autosave.
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return;
		}

		// Return if doing ajax :: Quick edits.
		if ( defined( 'DOING_AJAX' ) && DOING_AJAX ) {
			return;
		}

		if ( ! isset( $_POST['meta_box_nonce'] ) ) {
			return;
		}

		if ( ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['meta_box_nonce'] ) ), 'meta_box_nonce' ) ) {
			return;
		}

		// Return on post trash, quick-edit, new post.
		if ( empty( $_POST['action'] ) || 'editpost' != $_POST['action'] ) {
			return;
		}

		$crm_connect_manager = new Woo_Crm_Connect_Keap();
		$feed_id = self::isInstantSyncRequired();

		if ( ! empty( $feed_id ) && is_numeric( $feed_id ) ) {

			$keap = Woo_Crm_Connect_Keap::get_instance();

			$request = $crm_connect_manager->getRequest(
				'shop_order',
				$feed_id,
				$post_id
			);

		   /**
			* Keap new order request filter hook.
			*
			* @since    1.0.0
			*/
			$request = apply_filters(
				'woo_crm_woo_keap_new_order_request',
				$request,
				$post_id
			);

			$record_type = $crm_connect_manager->getFeed(
				$feed_id,
				'crm_object'
			);

			$feed_title = $keap->getFeedTitle( $feed_id );

			$log_data = array(
				'woo_id'   => $post_id,
				'feed_id'  => $feed_id,
				'woo_object' => $post->post_type,
				'feed_title' => $feed_title,
			);

			$crm_integration_keap_api = Crm_Integration_Keap_Api::get_instance();
			$result = $crm_integration_keap_api->create_single_record(
				$record_type,
				$request,
				false,
				$log_data
			);

		}
	}

	/**
	 * Prepare/Fire a request whenever a shop order is created/updated.
	 *
	 * @param string $post_id - Woo Object post ID.
	 * @param string $post    - Woo Object post.
	 *
	 * @since  1.0.0
	 */
	public function shopOrderUpdated( $post_id, $post = array() ) {
		
		$wc_order = wc_get_order($post_id);
		if ( 'pending' == $wc_order->get_status() ) {
			return;
		}
		$feed_id = self::isInstantSyncRequired();
		if ( ! empty( $feed_id ) && is_numeric( $feed_id ) ) {
			$this->performShopOrderSync( $feed_id, $post_id );
		} elseif ( ! empty( $feed_id ) && is_array( $feed_id ) ) {
			foreach ( $feed_id as $key => $f_id ) {
				$this->performShopOrderSync( $f_id, $post_id );
			}
		}
	}

	/**
	 * Do the shop order update by feed id.
	 *
	 * @param string $feed_id Feed id.
	 * @param string $post_id Order id.
	 *
	 * @since  1.0.0
	 */
	public function performShopOrderSync( $feed_id = false, $post_id = false ) {

		$crm_connect_manager = new Woo_Crm_Connect_Keap();
		$order = wc_get_order( $post_id );    

		$status = $order->get_status();
		if ( 'pending' == $status ) {

			$args = array(
				'post_type' => 'mwb_keap_feed',
				'post_status' => 'publish',
			);
			$all_feeds = get_posts($args);
			foreach ( $all_feeds as $k => $v ) {
				$record_type = $crm_connect_manager->getFeed(
					$v->ID,
					'crm_object'
				);
				if ( 'Contacts' == $record_type ) {
					$feed_id = $v->ID;
					$feed_title = $v->post_title;
					$rec_type = $record_type;
				}
			}
			$keap = Woo_Crm_Connect_Keap::get_instance();
			$request = $crm_connect_manager->getRequest(
				'shop_order',
				$feed_id,
				$post_id,
				$rec_type
			);
			$log_data = array(
				'woo_id'   => $post_id,
				'feed_id'  => $feed_id,
				'woo_object' => 'shop_order',
				'feed_title' => $feed_title,
			);

			$filter_exist = $this->maybe_check_filter( $feed_id );
			if ( ( isset( $filter_exist[2] ) && ! empty( $filter_exist[2][1]['field'] ) && '-1' != $filter_exist[2][1]['field'] ) || ( isset( $filter_exist[1] ) && ! empty( $filter_exist[1][1]['field'] ) && '-1' != $filter_exist[1][1]['field'] ) || ( isset( $filter_exist[3] ) && ! empty( $filter_exist[3][1]['field'] ) && '-1' != $filter_exist[3][1]['field'] ) || ( isset( $filter_exist[4] ) && ! empty( $filter_exist[4][1]['field'] ) && '-1' != $filter_exist[4][1]['field'] ) ) {
				$filter_result = $this->wps_validate_filter( $filter_exist, $request );
				if ( true === $filter_result ) {
					$crm_integration_keap_api = Crm_Integration_Keap_Api::get_instance();
					$request_data = $crm_integration_keap_api->json_contacts_data( $request, 16 );
					$endpoint = 'https://api.infusionsoft.com/crm/rest/v1/contacts';
					$result = $crm_integration_keap_api->create_or_update_contacts(
						$rec_type,
						$request_data,
						$endpoint,
						$post_id,
						false,
						$log_data
					);
					
					if ( ! empty($result['data']['id'])) {
						$keap_id = $result['data']['id'];
					}
					if (Crm_Integration_For_Keap_Admin::is_instant_tag_enable()) {  
						$args = array( 'shop_order', $feed_id, $post_id, $rec_type, $keap_id ); 
						wp_schedule_single_event( time() + 30, 'mwb_woo_keap_real_time_tag_sync', $args );
					}
				}
			} else {
				$crm_integration_keap_api = Crm_Integration_Keap_Api::get_instance();
				$request_data = $crm_integration_keap_api->json_contacts_data( $request, 16 );
				$endpoint = 'https://api.infusionsoft.com/crm/rest/v1/contacts';
				$result = $crm_integration_keap_api->create_or_update_contacts(
					$rec_type,
					$request_data,
					$endpoint,
					$post_id,
					false,
					$log_data
				);
				
				if ( ! empty($result['data']['id'])) {
					$keap_id = $result['data']['id'];
				}
				if (Crm_Integration_For_Keap_Admin::is_instant_tag_enable()) {  
					$args = array( 'shop_order', $feed_id, $post_id, $rec_type, $keap_id ); 
					wp_schedule_single_event( time() + 30, 'mwb_woo_keap_real_time_tag_sync', $args );
				}
			}
		} elseif ( ! empty( $feed_id ) && is_numeric( $feed_id ) ) {

			if ( OrderUtil::custom_orders_table_usage_is_enabled() ) {
				// HPOS enabled
				$post_type = OrderUtil::get_order_type( $post_id );
				if ( empty( $post_type ) ) {
					$post_type           = get_post( $post_id)->post_type;
				}
			} else {
				$post_type           = get_post( $post_id )->post_type;
			}
				$keap = Woo_Crm_Connect_Keap::get_instance();
				$woo_id = $post_id;
				$record_type = $crm_connect_manager->getFeed(
					$feed_id,
					'crm_object'
				);
	
				$request = $crm_connect_manager->getRequest(
					$post_type,
					$feed_id,
					$post_id,
					$record_type
				);

				$filter_exist = $this->maybe_check_filter( $feed_id );
			if ( ( isset( $filter_exist[2] ) && ! empty( $filter_exist[2][1]['field'] ) && '-1' != $filter_exist[2][1]['field'] ) || ( isset( $filter_exist[1] ) && ! empty( $filter_exist[1][1]['field'] ) && '-1' != $filter_exist[1][1]['field'] ) || ( isset( $filter_exist[3] ) && ! empty( $filter_exist[3][1]['field'] ) && '-1' != $filter_exist[3][1]['field'] ) || ( isset( $filter_exist[4] ) && ! empty( $filter_exist[4][1]['field'] ) && '-1' != $filter_exist[4][1]['field'] ) ) {
				$filter_result = $this->wps_validate_filter( $filter_exist, $request );
				if ( true === $filter_result ) {
					/**
					* Keap new order request filter hook.
					*
					* @since    1.0.0
					*/
					$request = apply_filters(
						'woo_crm_woo_keap_new_order_request',
						$request,
						$post_id
					);
			
					$log_data = array(
						'woo_id'   => $post_id,
						'feed_id'  => $feed_id,
						'woo_object' => $post_type,
						'feed_title' => $keap->getFeedTitle( $feed_id ),
					);
					if ( 'Contacts' == $record_type ) {
			
						$crm_integration_keap_api = Crm_Integration_Keap_Api::get_instance();
						$request_data = $crm_integration_keap_api->json_contacts_data( $request, $feed_id );
						$endpoint = 'https://api.infusionsoft.com/crm/rest/v1/contacts';
						$result = $crm_integration_keap_api->create_or_update_contacts(
							$record_type,
							$request_data,
							$endpoint,
							$woo_id,
							false,
							$log_data
						);
							
						if ( ! empty($result['data']['id'])) {
							$keap_id = $result['data']['id'];
						}
						if (Crm_Integration_For_Keap_Admin::is_instant_tag_enable()) {  
							$args = array( $post_type, $feed_id, $post_id, $record_type, $keap_id );    
							wp_schedule_single_event( time() + 30, 'mwb_woo_keap_real_time_tag_sync', $args );
						}
			
					} elseif ( 'Sales_Orders' == $record_type) {
						$crm_integration_keap_api = Crm_Integration_Keap_Api::get_instance();
						$endpoint = 'https://api.infusionsoft.com/crm/rest/v1/orders';
						$ord = wc_get_order( $woo_id );
						$coupon_code_amount = 0;
						if ( ! empty( $ord ) ) {
							$ord_data = $ord->get_data();
							if ( !empty( $ord_data['coupon_lines'] ) ) {
								foreach ( $ord_data['coupon_lines'] as $coupon_key => $coupon_value ) {
									$coupon_code_data = $coupon_value->get_data();
									$coupon_code = $coupon_code_data['code'];
									$coupon_code_amount = $coupon_code_data['discount'];
									$request['promo_codes'] = $coupon_code;
								}
							} else {
								$request['promo_codes'] = '';
							}
							$order_status = $ord_data['status'];
						}
							
						if ( !empty( $order_status ) && 'failed' != $order_status ) {
			
							// 2.1.0 start.
							$ordr = wc_get_order( $woo_id );
							if ( ! empty( $ordr ) ) {
								$ordr_data = $ordr->get_data();
								$shipping_total = 0;
								if ( !empty( $ordr_data['shipping_total'] ) ) {
									$shipping_total = $ordr_data['shipping_total'];
									$endpoint3 = 'https://api.infusionsoft.com/crm/rest/v1/products/';
									$req_data['product_name'] = 'Shipping';
									$req_data['product_price'] = $shipping_total;
									$req_data['active'] = true;
									$req_data['subscription_only'] = false;
									$req_data = json_encode( $req_data );
									$api_class = new Crm_Integration_Keap_Api();
									$header = $api_class->get_auth_header();
									$response = $api_class->post( $endpoint3, $req_data, $header );
									$p_id = $response['data']['id'];
						
									$item = array(
										'price' => $shipping_total,
										'quantity' => 1,
										'product_id' => $p_id,
									);
									array_push( $request['order_items'], $item );
								}
								$order_tax = 0;
								if ( !empty( $ordr_data['cart_tax'] ) ) {
									$order_tax = $ordr_data['cart_tax'];
									$endpoint2 = 'https://api.infusionsoft.com/crm/rest/v1/products/';
									$req_data2['product_name'] = 'Tax';
									$req_data2['product_price'] = $order_tax;
									$req_data2['active'] = true;
									$req_data2['subscription_only'] = false;
									$req_data2 = json_encode( $req_data2 );
									$api_class2 = new Crm_Integration_Keap_Api();
									$header2 = $api_class2->get_auth_header();
									$response2 = $api_class2->post( $endpoint2, $req_data2, $header2 );
									$p_id2 = $response2['data']['id'];
						
									$item2 = array(
										'price' => $order_tax,
										'quantity' => 1,
										'product_id' => $p_id2,
									);
									array_push( $request['order_items'], $item2 );
								}
								$shipping_tax = 0;
								if ( !empty( $ordr_data['shipping_tax'] ) ) {
									$shipping_tax = $ordr_data['shipping_tax'];
									$endpoint1 = 'https://api.infusionsoft.com/crm/rest/v1/products/';
									$req_data1['product_name'] = 'Shipping Tax';
									$req_data1['product_price'] = $shipping_tax;
									$req_data1['active'] = true;
									$req_data1['subscription_only'] = false;
									$req_data1 = json_encode( $req_data1 );
									$api_class1 = new Crm_Integration_Keap_Api();
									$header1 = $api_class1->get_auth_header();
									$response1 = $api_class->post( $endpoint1, $req_data1, $header1 );
									$p_id1 = $response1['data']['id'];
						
									$item1 = array(
										'price' => $shipping_tax,
										'quantity' => 1,
										'product_id' => $p_id1,
									);
									array_push( $request['order_items'], $item1 );
								}
							}
							// 2.1.0 end.
							$request_data = $crm_integration_keap_api->json_order_data( $request, $feed_id, $post_id );
							if ( empty( wps_keap_get_meta_data( $post_id, 'mwb_keap_feed_' . $feed_id . '_association', true ) ) ) {
								$result = $crm_integration_keap_api->create_order_record(
									$record_type,
									$request_data,
									$endpoint,
									$woo_id,
									true,
									$log_data
								);
								if ( isset( $result['code'] ) && '201' == $result['code'] && 'Created' == $result['message'] ) {
									// Create order payment plan.
									if (!empty( $result['data']['id'] ) ) {
				
										$keap_order_id = $result['data']['id'];
				
									}
				
									wps_keap_update_meta_data( $woo_id, '_mwb_keap_order_id', $keap_order_id);
				
									$endpoint = 'https://api.infusionsoft.com/crm/rest/v1/orders/' . $keap_order_id . '/payments';
									$o_data = wc_get_order($woo_id);
									$o_o_data = $o_data->get_data();
									$p_method = '';
									if ( !empty( $o_o_data['payment_method_title'] ) ) {
										$p_method = $o_o_data['payment_method_title'];
									}
									if ( !empty( $p_method ) && 'Cash on delivery' != $p_method ) {
										$request_data = $crm_integration_keap_api->json_data_for_order_payment( $result['data'], $p_method, $request, $request['payment_method'], $request['payment_title'], $request['order_note'], $coupon_code_amount, $shipping_total, $order_tax, $shipping_tax );
				
										$log_data = array(
											'woo_id'   => $woo_id,
											'feed_id'  => $feed_id,
											'woo_object' => 'Payment Plan',
										);
										$result_payment = $crm_integration_keap_api->create_order_payment_record(
											$record_type,
											$request_data,
											$endpoint,
											$woo_id,
											true,
											$log_data
										);
									}
									if ( 0 != $coupon_code_amount ) {
										$request_data_coupon = $crm_integration_keap_api->reduce_coupon_amount( $result['data'], $p_method, $request, $request['payment_method'], $request['payment_title'], 'Coupon code', $coupon_code_amount );
										$log_data = array(
											'woo_id'   => $woo_id,
											'feed_id'  => $feed_id,
											'woo_object' => 'Payment Plan',
										);
										$result_payment = $crm_integration_keap_api->create_order_payment_record(
											$record_type,
											$request_data_coupon,
											$endpoint,
											$woo_id,
											true,
											$log_data
										);
									}
				
								}
								if (! empty( $result['data']['id'])) {
				
									$keap_id = $result['data']['id'];
								}
								$is_success = Crm_Integration_For_Keap_Admin::is_success_res( $result );
				
								Crm_Integration_For_Keap_Admin::set_woo_response_meta_for_count( $feed_id, $woo_id, $keap_id, $is_success );
							}
						}
					}
				}
			} else {
				/**
				* Keap new order request filter hook.
				*
				* @since    1.0.0
				*/
				$request = apply_filters(
					'woo_crm_woo_keap_new_order_request',
					$request,
					$post_id
				);
		
				$log_data = array(
					'woo_id'   => $post_id,
					'feed_id'  => $feed_id,
					'woo_object' => $post_type,
					'feed_title' => $keap->getFeedTitle( $feed_id ),
				);
				if ( 'Contacts' == $record_type ) {
		
					$crm_integration_keap_api = Crm_Integration_Keap_Api::get_instance();
					$request_data = $crm_integration_keap_api->json_contacts_data( $request, $feed_id );
					$endpoint = 'https://api.infusionsoft.com/crm/rest/v1/contacts';
					$result = $crm_integration_keap_api->create_or_update_contacts(
						$record_type,
						$request_data,
						$endpoint,
						$woo_id,
						false,
						$log_data
					);
						
					if ( ! empty($result['data']['id'])) {
						$keap_id = $result['data']['id'];
					}
					if (Crm_Integration_For_Keap_Admin::is_instant_tag_enable()) {  
						$args = array( $post_type, $feed_id, $post_id, $record_type, $keap_id );    
						wp_schedule_single_event( time() + 30, 'mwb_woo_keap_real_time_tag_sync', $args );
					}
		
				} elseif ( 'Sales_Orders' == $record_type) {
					$crm_integration_keap_api = Crm_Integration_Keap_Api::get_instance();
					$endpoint = 'https://api.infusionsoft.com/crm/rest/v1/orders';
					$ord = wc_get_order( $woo_id );
					$coupon_code_amount = 0;
					if ( ! empty( $ord ) ) {
						$ord_data = $ord->get_data();
						if ( !empty( $ord_data['coupon_lines'] ) ) {
							foreach ( $ord_data['coupon_lines'] as $coupon_key => $coupon_value ) {
								$coupon_code_data = $coupon_value->get_data();
								$coupon_code = $coupon_code_data['code'];
								$coupon_code_amount = $coupon_code_data['discount'];
								$request['promo_codes'] = $coupon_code;
							}
						} else {
							$request['promo_codes'] = '';
						}
						$order_status = $ord_data['status'];
					}
						
					if ( !empty( $order_status ) && 'failed' != $order_status ) {
		
						// 2.1.0 start.
						$ordr = wc_get_order( $woo_id );
						if ( ! empty( $ordr ) ) {
							$ordr_data = $ordr->get_data();
							$shipping_total = 0;
							if ( !empty( $ordr_data['shipping_total'] ) ) {
								$shipping_total = $ordr_data['shipping_total'];
								$endpoint3 = 'https://api.infusionsoft.com/crm/rest/v1/products/';
								$req_data['product_name'] = 'Shipping';
								$req_data['product_price'] = $shipping_total;
								$req_data['active'] = true;
								$req_data['subscription_only'] = false;
								$req_data = json_encode( $req_data );
								$api_class = new Crm_Integration_Keap_Api();
								$header = $api_class->get_auth_header();
								$response = $api_class->post( $endpoint3, $req_data, $header );
								$p_id = $response['data']['id'];
					
								$item = array(
									'price' => $shipping_total,
									'quantity' => 1,
									'product_id' => $p_id,
								);
								array_push( $request['order_items'], $item );
							}
							$order_tax = 0;
							if ( !empty( $ordr_data['cart_tax'] ) ) {
								$order_tax = $ordr_data['cart_tax'];
								$endpoint2 = 'https://api.infusionsoft.com/crm/rest/v1/products/';
								$req_data2['product_name'] = 'Tax';
								$req_data2['product_price'] = $order_tax;
								$req_data2['active'] = true;
								$req_data2['subscription_only'] = false;
								$req_data2 = json_encode( $req_data2 );
								$api_class2 = new Crm_Integration_Keap_Api();
								$header2 = $api_class2->get_auth_header();
								$response2 = $api_class2->post( $endpoint2, $req_data2, $header2 );
								$p_id2 = $response2['data']['id'];
					
								$item2 = array(
									'price' => $order_tax,
									'quantity' => 1,
									'product_id' => $p_id2,
								);
								array_push( $request['order_items'], $item2 );
							}
							$shipping_tax = 0;
							if ( !empty( $ordr_data['shipping_tax'] ) ) {
								$shipping_tax = $ordr_data['shipping_tax'];
								$endpoint1 = 'https://api.infusionsoft.com/crm/rest/v1/products/';
								$req_data1['product_name'] = 'Shipping Tax';
								$req_data1['product_price'] = $shipping_tax;
								$req_data1['active'] = true;
								$req_data1['subscription_only'] = false;
								$req_data1 = json_encode( $req_data1 );
								$api_class1 = new Crm_Integration_Keap_Api();
								$header1 = $api_class1->get_auth_header();
								$response1 = $api_class->post( $endpoint1, $req_data1, $header1 );
								$p_id1 = $response1['data']['id'];
					
								$item1 = array(
									'price' => $shipping_tax,
									'quantity' => 1,
									'product_id' => $p_id1,
								);
								array_push( $request['order_items'], $item1 );
							}
						}
						// 2.1.0 end.
						$request_data = $crm_integration_keap_api->json_order_data( $request, $feed_id, $post_id );
						if ( empty( wps_keap_get_meta_data( $post_id, 'mwb_keap_feed_' . $feed_id . '_association', true ) ) ) {
							$result = $crm_integration_keap_api->create_order_record(
								$record_type,
								$request_data,
								$endpoint,
								$woo_id,
								true,
								$log_data
							);
							if ( isset( $result['code'] ) && '201' == $result['code'] && 'Created' == $result['message'] ) {
								// Create order payment plan.
								if (!empty( $result['data']['id'] ) ) {
			
									$keap_order_id = $result['data']['id'];
			
								}
			
								wps_keap_update_meta_data( $woo_id, '_mwb_keap_order_id', $keap_order_id);
			
								$endpoint = 'https://api.infusionsoft.com/crm/rest/v1/orders/' . $keap_order_id . '/payments';
								$o_data = wc_get_order($woo_id);
								$o_o_data = $o_data->get_data();
								$p_method = '';
								if ( !empty( $o_o_data['payment_method_title'] ) ) {
									$p_method = $o_o_data['payment_method_title'];
								}
								if ( !empty( $p_method ) && 'Cash on delivery' != $p_method ) {
									$request_data = $crm_integration_keap_api->json_data_for_order_payment( $result['data'], $p_method, $request, $request['payment_method'], $request['payment_title'], $request['order_note'], $coupon_code_amount, $shipping_total, $order_tax, $shipping_tax );
			
									$log_data = array(
										'woo_id'   => $woo_id,
										'feed_id'  => $feed_id,
										'woo_object' => 'Payment Plan',
									);
									$result_payment = $crm_integration_keap_api->create_order_payment_record(
										$record_type,
										$request_data,
										$endpoint,
										$woo_id,
										true,
										$log_data
									);
								}
								if ( 0 != $coupon_code_amount ) {
									$request_data_coupon = $crm_integration_keap_api->reduce_coupon_amount( $result['data'], $p_method, $request, $request['payment_method'], $request['payment_title'], 'Coupon code', $coupon_code_amount );
									$log_data = array(
										'woo_id'   => $woo_id,
										'feed_id'  => $feed_id,
										'woo_object' => 'Payment Plan',
									);
									$result_payment = $crm_integration_keap_api->create_order_payment_record(
										$record_type,
										$request_data_coupon,
										$endpoint,
										$woo_id,
										true,
										$log_data
									);
								}
			
							}
							if (! empty( $result['data']['id'])) {
			
								$keap_id = $result['data']['id'];
							}
							$is_success = Crm_Integration_For_Keap_Admin::is_success_res( $result );
			
							Crm_Integration_For_Keap_Admin::set_woo_response_meta_for_count( $feed_id, $woo_id, $keap_id, $is_success );
						}
					}
				}
			}
		}
	}



	/**
	 * Check if filter exists in feed.
	 *
	 * @param     int $feed_id    Feed ID.
	 * @since     1.0.0
	 * @return    bool|array
	 */
	public function maybe_check_filter( $feed_id = '' ) {

		if ( empty( $feed_id ) ) {
			return;
		}
	
		if ( get_post_meta( $feed_id, 'condition_filters', true ) ) {
			$meta = get_post_meta( $feed_id, 'condition_filters', true );

			if ( ! empty( $meta ) && is_array( $meta ) && count( $meta ) > 0 ) {
				return $meta;
			}
		}

		return false;
	}


	/**
	 * Validate form entries with feeds filter conditions.
	 *
	 * @param     array $filters    An array of filter data.
	 * @param     array $data       Form data.
	 * @since     1.0.0
	 * @return    bool
	 */
	public function wps_validate_filter( $filters = array(), $data = array() ) {

		$result = true;
		if ( ! empty( $filters ) && is_array( $filters ) ) {

			foreach ( $filters as $or_key => $or_filters ) {
				$result = true;

				if ( is_array( $or_filters ) ) {

					foreach ( $or_filters as $and_key => $and_filter ) {
						if ( '-1' == $and_filter['field'] || '-1' == $and_filter['option'] ) { // phpcs:ignore
							return array( 'result' => false );
						}

						$form_field = $and_filter['field'];
						$feed_value = ! empty( $and_filter['value'] ) ? $and_filter['value'] : '';
						$entry_val  = $this->wps_get_entry_values( $form_field, $data );
						$result     = $this->is_value_allowed( $and_filter['option'], $feed_value, $entry_val );

						if ( false == $result ) { // phpcs:ignore
							break;
						}
					}
				}

				if ( true === $result ) {
					break;
				}
			}
		}

		return $result;
	}

	/**
	 * Verify and get entered field values.
	 *
	 * @param     string $field      Form field whose value to verify.
	 * @param     array  $entries    An array of form entries.
	 * @since     1.0.0
	 * @return    mixed              value of the field
	 */
	public function wps_get_entry_values( $field, $entries ) {

		$value = false;

		$form_fields = $this->form_fields;
		$field_type  = isset( $form_fields[ $field ]['type'] ) ? $form_fields[ $field ]['type'] : '';

		if ( ! empty( $field ) || ! empty( $entries ) || is_array( $entries ) ) {

			if ( isset( $entries[ $field ] ) ) {
				$value = $entries[ $field ];

				if ( is_array( $value ) && ! empty( $value['value'] ) ) {
					$value = $value['value'];
				} elseif ( ! is_array( $value ) ) {
					$value = maybe_unserialize( $value );
				}
			}
		}

		if ( ! empty( $value ) && 'file' == $field_type ) { // phpcs:ignore
			$value = false;
		} elseif ( is_array( $value ) && 1 == count( $value ) ) { // phpcs:ignore
			$value = implode( ' ', $value );
		}

		return $value;
	}

	/**
	 * Validate form values with conditions.
	 *
	 * @param    String $option_type    Filter conditon type.
	 * @param    String $feed_value     Value to compare with entry value.
	 * @param    String $form_value     Entry value .
	 *
	 * @since    1.0.0
	 * @return   bool
	 */
	public function is_value_allowed( $option_type = false, $feed_value = false, $form_value = false ) {

		if ( false == $option_type || false === $feed_value ) { // phpcs:ignore
			return;
		}

		$time   = current_time( 'timestamp' ); // phpcs:ignore
		$result = false;
		if ( false != $form_value ) { // phpcs:ignore

			switch ( $option_type ) {

				case 'exact_match':
					if ( $feed_value === $form_value ) { // phpcs:ignore
						$result = true;
					}
					break;

				case 'no_exact_match':
					if ( $feed_value !== $form_value ) { // phpcs:ignore
						$result = true;
					}
					break;

				case 'contains':
					if ( false !== strpos( $form_value, $feed_value ) ) {
						$result = true;
					}
					break;

				case 'not_contains':
					if ( false === strpos( $form_value, $feed_value ) ) {
						$result = true;
					}
					break;

				case 'exist':
					if ( false !== strpos( $feed_value, $form_value ) ) {
						$result = true;
					}
					break;

				case 'not_exist':
					if ( false === strpos( $feed_value, $form_value ) ) {
						$result = true;
					}
					break;

				case 'starts':
					if ( 0 === strpos( $form_value, $feed_value ) ) {
						$result = true;
					}
					break;

				case 'not_starts':
					if ( 0 !== strpos( $form_value, $feed_value ) ) {
						$result = true;
					}
					break;

				case 'ends':
					if ( strlen( $form_value ) == strpos( $form_value, $feed_value ) + strlen( $feed_value ) ) { // phpcs:ignore
						$result = true;
					}
					break;

				case 'not_ends':
					if ( strlen( $form_value ) != strpos( $form_value, $feed_value ) + strlen( $feed_value ) ) { // phpcs:ignore
						$result = true;
					}
					break;

				case 'less_than':
					if ( (float) $form_value < (float) $feed_value ) {
						$result = true;
					}
					break;

				case 'greater_than':
					if ( (float) $form_value > (float) $feed_value ) {
						$result = true;
					}
					break;

				case 'less_than_date':
					if ( strtotime( $form_value, $time ) < strtotime( $feed_value, $time ) ) {
						$result = true;
					}
					break;

				case 'greater_than_date':
					if ( strtotime( $form_value, $time ) > strtotime( $feed_value, $time ) ) {
						$result = true;
					}
					break;

				case 'equal_date':
					if ( strtotime( $form_value, $time ) == strtotime( $feed_value, $time ) ) { // phpcs:ignore
						$result = true;
					}
					break;

				case 'empty':
					if ( empty( $form_value ) ) {
						$result = true;
					}
					break;

				case 'not_empty':
					if ( ! empty( $form_value ) ) {
						$result = true;
					}
					break;

				case 'only_number':
					if ( is_numeric( $form_value ) ) {
						$result = true;
					}
					break;

				case 'only_text':
					if ( preg_match( '/[^A-Za-z0-9]/', $form_value ) ) {
						$result = true;
					}
					break;

				default:
					$result = false;
					break;
			}
		}
		return $result;
	}

	/**
	 * Prepare/Retrieve a request full of all the post entities specified.
	 *
	 * Retrieves the bulk data in crm request format.
	 *
	 * @param string $object_type      Woo Object post type.
	 * @param string $paged            Woo pagination.
	 * @param string $feed_id          Feed id.
	 * @param string $is_oneclick_sync Is one click sync or not.
	 *
	 * @since  1.0.0
	 * @return array $bulk_request
	 */
	public function getBulkData( $object_type, $paged = 1, $feed_id = false, $is_oneclick_sync = false ) {

		if ( false == $feed_id ) {
			return;
		}

		$keap = Woo_Crm_Connect_Keap::get_instance();
		$crm_integration_keap_api = Crm_Integration_Keap_Api::get_instance();

		$record_type = $keap->getFeed( $feed_id, 'crm_object' );
		$limit = 1;

		/*New Code record type management*/

		if ( 'Contacts' == $record_type ) {

			$object_type = 'shop_order';

			if ( OrderUtil::custom_orders_table_usage_is_enabled() ) {
				$args = array(
					'type'      => $object_type,
					'status'    => 'any',
					'limit' => $limit,
					'paged' => $paged,
					'meta_query' => array(
						'relation' => 'AND',
						array(
							'key' => 'mwb_keap_feed_' . $feed_id . '_association',
							'compare' => 'NOT EXISTS',
						),
					),
				);

			} else {
				$args = array(
					'post_type'  => $object_type,
					'posts_per_page' => $limit,
					'post_status' => 'any',
					'paged' => $paged,
					'meta_query' => array(
						'relation' => 'AND',
						array(
							'key' => 'mwb_keap_feed_' . $feed_id . '_association',
							'compare' => 'NOT EXISTS',
						),
					),
				);

			}

			if ( false == $is_oneclick_sync ) {
				if ( !empty( $args['meta_query'] ) ) {
					unset( $args['meta_query'] );
				}
				if ( !empty( $args['field_query'] ) ) {
					unset( $args['field_query'] );
				}
			}

			try {

				if ( OrderUtil::custom_orders_table_usage_is_enabled() ) {
					$query_result = wc_get_orders( $args );
					$args1 = $args;
					unset( $args1['limit'] );
					unset( $args1['paged'] );
					$args1['paginate'] = true;
					$query_for_total_count = wc_get_orders( $args1 );
					$total = $query_for_total_count->total;

					$bulk_request = array();
					$bulk_ids     = array();
					if ( !empty( $query_result ) ) {
						foreach ( $query_result as $k => $v ) {
		
							$request = $keap->getRequest( $object_type, $feed_id, $v->get_id(), $record_type );
							$request['contact_id'] = $v->get_id();
							array_push( $bulk_request, $request );
							$bulk_ids[] = $v->get_id();

							/**
							* Keap update order bulk request filter hook.
							*
							* @since    1.0.0
							*/
							apply_filters(
								'woo_crm_woo_keap_update_order_bulk_request',
								$bulk_request,
								$bulk_ids
							);
						}
					}

				} else {
					$order_query = new WP_Query( $args );
					$bulk_request = array();
					$bulk_ids = array();

					$total = $order_query->found_posts;

					while ( $order_query->have_posts() ) :
						$order_query->the_post();
						$request = $keap->getRequest( $object_type, $feed_id, get_the_ID(), $record_type );
						$request['contact_id'] = get_the_ID();
						array_push( $bulk_request, $request );
						$bulk_ids[] = get_the_ID();

						/**
						* Keap update order bulk request filter hook.
						*
						* @since    1.0.0
						*/
						apply_filters(
							'woo_crm_woo_keap_update_order_bulk_request',
							$bulk_request,
							$bulk_ids
						);
					endwhile;
				}

			} catch ( \Throwable $th ) {

				$msg = $th->getMessage();

				if ( defined( 'WP_DEBUG' ) && WP_DEBUG && current_user_can( 'manage_woocommerce' ) ) {
					echo esc_html( $msg );
				}
			}

			$total_batch = ceil( $total / $limit );
			$current_offset = $paged;

			$result = array(
				'total_posts' => $total,
				'total_batch' => $total_batch,
				'offset'    => ++$paged,
				'request'   => $bulk_request,
				'bulk_ids'    => $bulk_ids,
			);

			if ( $current_offset == $total_batch ) {
				update_option( 'mwb_crm_' . $record_type . '_feed_onboarded', 'true' );
				update_option( 'mwb_crm_' . $record_type . '_feed_final_reponse', $result );
			}

			return $result;

		} elseif ( 'Sales_Orders' == $record_type ) {

			$object_type = 'shop_order';

			if ( OrderUtil::custom_orders_table_usage_is_enabled() ) {
				$args = array(
					'type'      => $object_type,
					'limit' => $limit,
					'status'    => 'any',
					'paged' => $paged,
					'meta_query' => array(
						'relation' => 'AND',
						array(
							'key' => 'mwb_keap_feed_' . $feed_id . '_association',
							'compare' => 'NOT EXISTS',
						),
					),
				);

			} else {
				$args = array(
					'post_type'  => $object_type,
					'posts_per_page' => $limit,
					'post_status' => 'any',
					'paged' => $paged,
					'meta_query' => array(
						'relation' => 'AND',
						array(
							'key' => 'mwb_keap_feed_' . $feed_id . '_association',
							'compare' => 'NOT EXISTS',
						),
					),
				);

			}

			if ( false == $is_oneclick_sync ) {
				if ( !empty( $args['meta_query'] ) ) {
					unset( $args['meta_query'] );
				}
				if ( !empty( $args['field_query'] ) ) {
					unset( $args['field_query'] );
				}
			}

			try {

				if ( OrderUtil::custom_orders_table_usage_is_enabled() ) {

					$query_result = wc_get_orders( $args );
					$args1 = $args;
					unset( $args1['limit'] );
					unset( $args1['paged'] );
					$args1['paginate'] = true;
					$query_for_total_count = wc_get_orders( $args1 );
					$total = $query_for_total_count->total;

					$bulk_request = array();
					$bulk_ids     = array();
					if ( !empty( $query_result ) ) {
						foreach ( $query_result as $k => $v ) {
		
							$request = $keap->getRequest( $object_type, $feed_id, $v->get_id(), $record_type );
							$request['contact_id'] = $v->get_id();
							array_push( $bulk_request, $request );
							$bulk_ids[] = $v->get_id();

							/**
							* Keap update order bulk request filter hook.
							*
							* @since    1.0.0
							*/
							apply_filters(
								'woo_crm_woo_keap_update_order_bulk_request',
								$bulk_request,
								$bulk_ids
							);
						}
					}

				} else {
					$order_query = new WP_Query( $args );

					$bulk_request = array();
					$bulk_ids = array();

					$total = $order_query->found_posts;

					while ( $order_query->have_posts() ) :
						$order_query->the_post();
						$request = $keap->getRequest( $object_type, $feed_id, get_the_ID(), $record_type );
						$request['contact_id'] = get_the_ID();
						array_push( $bulk_request, $request );
						$bulk_ids[] = get_the_ID();

						/**
						* Keap update order bulk request filter hook.
						*
						* @since    1.0.0
						*/
						apply_filters(
							'woo_crm_woo_keap_update_order_bulk_request',
							$bulk_request,
							$bulk_ids
						);
					endwhile;
				}
				
			} catch ( \Throwable $th ) {
				$msg = $th->getMessage();
				if ( defined( 'WP_DEBUG' ) && WP_DEBUG && current_user_can( 'manage_woocommerce' ) ) {
					echo esc_html( $msg );
				}
			}

			if ( ! empty( $bulk_request ) ) {

				foreach ( $bulk_request as $single_key => $single_order ) {
					
					$keap_api = Crm_Integration_Keap_Api::get_instance();
					$ord = wc_get_order( $single_order['order_id'] );
					$coupon_code_amount = 0;
					if ( ! empty( $ord ) ) {
						$ord_data = $ord->get_data();
						if ( !empty( $ord_data['coupon_lines'] ) ) {
							foreach ( $ord_data['coupon_lines'] as $coupon_key => $coupon_value ) {
								$coupon_code_data = $coupon_value->get_data();
								$coupon_code = $coupon_code_data['code'];
								$coupon_code_amount = $coupon_code_data['discount'];
								$single_order['promo_codes'] = $coupon_code;
							}
						} else {
							$single_order['promo_codes'] = '';
						}
						$order_status = $ord_data['status'];
					}
					if ( !empty( $order_status ) && 'failed' != $order_status ) {
						// 2.1.0 start.
						$ordr = wc_get_order( $single_order['order_id'] );
						if ( ! empty( $ordr ) ) {
							$ordr_data = $ordr->get_data();
							$shipping_total = 0;
							if ( !empty( $ordr_data['shipping_total'] ) ) {
								$shipping_total = $ordr_data['shipping_total'];
								$endpoint = 'https://api.infusionsoft.com/crm/rest/v1/products/';
								$req_data['product_name'] = 'Shipping';
								$req_data['product_price'] = $shipping_total;
								$req_data['active'] = true;
								$req_data['subscription_only'] = false;
								$req_data = json_encode( $req_data );
								$api_class = new Crm_Integration_Keap_Api();
								$header = $api_class->get_auth_header();
								$response = $api_class->post( $endpoint, $req_data, $header );
								$p_id = $response['data']['id'];
				
								$item = array(
									'price' => $shipping_total,
									'quantity' => 1,
									'product_id' => $p_id,
								);
								array_push( $single_order['order_items'], $item );
							}
							$order_tax = 0;
							if ( wps_keap_get_meta_data( $single_order['order_id'], '_order_tax', true ) ) {
								$order_tax = wps_keap_get_meta_data( $single_order['order_id'], '_order_tax', true );
								$endpoint2 = 'https://api.infusionsoft.com/crm/rest/v1/products/';
								$req_data2['product_name'] = 'Tax';
								$req_data2['product_price'] = $order_tax;
								$req_data2['active'] = true;
								$req_data2['subscription_only'] = false;
								$req_data2 = json_encode( $req_data2 );
								$api_class2 = new Crm_Integration_Keap_Api();
								$header2 = $api_class2->get_auth_header();
								$response2 = $api_class2->post( $endpoint2, $req_data2, $header2 );
								$p_id2 = $response2['data']['id'];
				
								$item2 = array(
									'price' => $order_tax,
									'quantity' => 1,
									'product_id' => $p_id2,
								);
								array_push( $single_order['order_items'], $item2 );
							}
							$shipping_tax = 0;
							if ( !empty( $ordr_data['shipping_tax'] ) ) {
								$shipping_tax = $ordr_data['shipping_tax'];
								$endpoint1 = 'https://api.infusionsoft.com/crm/rest/v1/products/';
								$req_data1['product_name'] = 'Shipping Tax';
								$req_data1['product_price'] = $shipping_tax;
								$req_data1['active'] = true;
								$req_data1['subscription_only'] = false;
								$req_data1 = json_encode( $req_data1 );
								$api_class1 = new Crm_Integration_Keap_Api();
								$header1 = $api_class1->get_auth_header();
								$response1 = $api_class->post( $endpoint1, $req_data1, $header1 );
								$p_id1 = $response1['data']['id'];
				
								$item1 = array(
									'price' => $shipping_tax,
									'quantity' => 1,
									'product_id' => $p_id1,
								);
								array_push( $single_order['order_items'], $item1 );
							}
						}
						// 2.1.0 end.
						$woo_id = $single_order['order_id'];
						$request_data = $keap_api->json_order_data( $single_order, $feed_id, $woo_id );
						$endpoint = 'https://api.infusionsoft.com/crm/rest/v1/orders';
						$keap_sync_order_id = wps_keap_get_meta_data( $woo_id , '_mwb_keap_order_id', true);
						$log_data = array(
							'woo_id'   => $woo_id,
							'feed_id'  => $feed_id,
							'woo_object' => 'shop_order',
						);
						
						if ( empty( $keap_sync_order_id ) ) {
	
							$result = $keap_api->create_order_record(
								$record_type,
								$request_data,
								$endpoint,
								$woo_id,
								true,
								$log_data
							);
	
							if ( isset( $result['code'] ) && '201' == $result['code'] && 'Created' == $result['message'] ) {
								// Create order payment plan.
								if (! empty( $result['data']['id'])) {
	
									$keap_order_id = $result['data']['id'];
								}
	
								wps_keap_update_meta_data( $woo_id, '_mwb_keap_order_id', $keap_order_id);
								$endpoint = 'https://api.infusionsoft.com/crm/rest/v1/orders/' . $keap_order_id . '/payments';
								$o_data = wc_get_order($woo_id);
								$o_o_data = $o_data->get_data();
								$p_method = '';
								if ( !empty( $o_o_data['payment_method_title'] ) ) {
									$p_method = $o_o_data['payment_method_title'];
								}
								if ( !empty( $p_method ) && 'Cash on delivery' != $p_method ) {
									$request_data = $keap_api->json_data_for_order_payment( $result['data'], $p_method, $single_order, $single_order['payment_method'], $single_order['payment_title'], $single_order['order_note'], $coupon_code_amount, $shipping_total, $order_tax, $shipping_tax );
	
									$log_data = array(
										'woo_id'   => $woo_id,
										'feed_id'  => $feed_id,
										'woo_object' => 'Payment Plan',
									);
									$result_payment = $keap_api->create_order_payment_record(
										$record_type,
										$request_data,
										$endpoint,
										$woo_id,
										true,
										$log_data
									);
								}
								if ( 0 != $coupon_code_amount ) {
									$request_data_coupon = $crm_integration_keap_api->reduce_coupon_amount( $result['data'], $p_method, $request, $request['payment_method'], $request['payment_title'], $request['order_note'], $coupon_code_amount );
									$log_data = array(
										'woo_id'   => $woo_id,
										'feed_id'  => $feed_id,
										'woo_object' => 'Payment Plan',
									);
									$result_payment = $crm_integration_keap_api->create_order_payment_record(
										$record_type,
										$request_data_coupon,
										$endpoint,
										$woo_id,
										true,
										$log_data
									);
								}
							}
							$is_success = Crm_Integration_For_Keap_Admin::is_success_res( $result );
							if (! empty( $result['data']['id'])) {
	
								$keap_id = $result['data']['id'];
							}
	
							Crm_Integration_For_Keap_Admin::set_woo_response_meta_for_count( $feed_id, $woo_id, $keap_id, $is_success );
						} else {
	
							continue;
						}
					}

				}
			}
			

			$total_batch = ceil( $total / $limit );
			$current_offset = $paged;
			$result = array(
				'total_posts' => $total,
				'total_batch' => $total_batch,
				'offset'    => ++$paged,
				'request'   => $bulk_request,
				'bulk_ids'    => $bulk_ids,
			);
			
			if ( $current_offset == $total_batch ) {
				update_option( 'mwb_crm_' . $record_type . '_feed_onboarded', 'true' );
				update_option( 'mwb_crm_' . $record_type . '_feed_final_reponse', $result );
			}

			return $result;

		} elseif ( 'Products' == $record_type ) {

			$object_type = array( 'product', 'product_variation' );

			$args = array(
				'post_type'  => $object_type,
				'posts_per_page' => $limit,
				'post_status' => 'publish',
				'paged' => $paged,
				'meta_query' => array(
					'relation' => 'AND',
					array(
						'key' => 'mwb_keap_feed_' . $feed_id . '_association',
						'compare' => 'NOT EXISTS',
					),
					array(
						'key' => 'mwb_keap_woo_main_var_prod',
						'compare' => 'NOT EXISTS',
					),
				),
			);

			if ( false == $is_oneclick_sync ) {
				unset( $args['meta_query'] );
				
			}

			try {

				$product_query = new WP_Query( $args );

				$object_type = 'product';
				$bulk_request = array();
				$bulk_ids = array();

				$total = $product_query->found_posts;

				while ( $product_query->have_posts() ) :

					$product_query->the_post();

					// Get product.
					$product = wc_get_product( get_the_ID() );

					if ( 'variable' == $product->get_type() ) {
						
						update_post_meta( $product->get_id(), 'mwb_keap_woo_main_var_prod', 'main_prod');
						$available_variations = $product->get_available_variations();

						if ( ! empty( $available_variations )
							&& is_array( $available_variations )
						) {
							foreach ( $available_variations as $key => $variation ) {
								$request = $keap->getRequest(
									$object_type,
									$feed_id,
									$variation['variation_id']
								);
								$request['active'] = 'true';
								$request['subscription_only'] = 'false';
								$request['product_id'] = $variation['variation_id'];

								array_push( $bulk_request, $request );

								$bulk_ids[] = $variation['variation_id'];
								
							}
						}
					} else {
						$request = $keap->getRequest(
							$object_type,
							$feed_id,
							get_the_ID()
						);

						$request['active'] = 'true';
						$request['subscription_only'] = 'false';
						$request['product_id'] = get_the_ID();

						array_push( $bulk_request, $request );
						$bulk_ids[] = get_the_ID();
					}

				   /**
					* Keap update order bulk request filter hook.
					*
					* @since    1.0.0
					*/
					apply_filters(
						'woo_crm_woo_keap_update_order_bulk_request',
						$bulk_request,
						$bulk_ids
					);

				endwhile;
				
				
			} catch ( \Throwable $th ) {
				$msg = $th->getMessage();

				if ( defined( 'WP_DEBUG' ) && WP_DEBUG && current_user_can( 'manage_woocommerce' ) ) {
					echo esc_html( $msg );
				}
			}
			$total_batch = ceil( $total / $limit );
			$current_offset = $paged;
			
			$result = array(
				'total_posts' => $total,
				'total_batch' => $total_batch,
				'offset'    => ++$paged,
				'request'   => $bulk_request,
				'bulk_ids'    => array_values(array_unique( $bulk_ids ) ),
			);
			
			if ( $current_offset == $total_batch ) {
				update_option( 'mwb_crm_' . $record_type . '_feed_onboarded', 'true' );
				update_option( 'mwb_crm_' . $record_type . '_feed_final_reponse', $result );
			}
			
			return $result;
		}

		return array();
	}

	/**
	 * Prepare/Retrieve a request full of all the post entities specified.
	 *
	 * Retrieves the bulk data in crm request format.
	 *
	 * @param string $order_id Woo Object post ID.
	 * @param string $order    Woo Object post.
	 *
	 * @since 1.0.0
	 */
	public function createAndUpdateContact( $order_id, $order ) {
		$this->shopOrderUpdated( $order_id );
	}

	/**
	 * Prepare/Retrieve a request full of all the post entities specified.
	 *
	 * Retrieves the bulk data in crm request format.
	 *
	 * @param string $order_id  Woo Object post ID.
	 * @param string $refund_id Woo Refund post ID.
	 *
	 * @since 1.0.0
	 */
	public function shopOrderRefunded( $order_id, $refund_id ) {
		$this->shopOrderUpdated( $order_id );
	}

	/**
	 * Prepare/Retrieve a request full of all the post entities specified.
	 *
	 * Retrieves the bulk data in crm request format.
	 *
	 * @param string $order_id                 Woo Object post ID.
	 * @param string $maybe_refund_id_or_order Woo Object for or refund ID.
	 *
	 * @since 1.0.0
	 */
	public function shopOrderStatusChanged(
		$order_id,
		$maybe_refund_id_or_order = false
	) {

		$feeds = self::getFeedIdByRequest();

		// Sort so that we might get deal before the sales orders.
		sort( $feeds );
		if ( ! empty( $feeds ) && is_array( $feeds ) ) {
			foreach ( $feeds as $key => $feed_id ) {
				$this->performShopOrderSync( $feed_id, $order_id );
			}
		}
	}

	// End of class.
}
