<?php
/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://wpswings.com/
 * @since      1.0.0
 *
 * @package    Integration_With_keap
 * @subpackage Integration_With_keap/admin/partials
 */

?>
<div id="mwb-feeds" class="mwb-content-wrap mwb-tabcontent">
	<ul class="mwb-about__list">
			<?php
			foreach ( $feeds as $key => $feed ) :

				$feed_title     = $feed->post_title;
				$active         = ( 'publish' === $feed->post_status ) ? 'yes' : 'no';
				$edit_link      = get_edit_post_link( $feed->ID );
				$feed_event     = $cpt_instance->get_feed_data( $feed->ID, 'feed_event', '' );
				$lead_source     = $cpt_instance->get_feed_data( $feed->ID, 'lead_source', '' );
				$crm_object     = $cpt_instance->get_feed_data( $feed->ID, 'crm_object', '' );
				$primary_field     = $cpt_instance->get_feed_data( $feed->ID, 'primary_field', '' );

				$default_feed     = $cpt_instance->get_feed_data( $feed->ID, 'default_feed', '' );

				if ( !empty( $feed_event ) ) {
					$feed_event_label = $feed_options[ $feed_event ];
				} else {
					$feed_event_label = '';
				}
				if ( !empty( $lead_source ) ) {
					$lead_source_label = $lead_options[ $lead_source ];
				} else {
					$lead_source_label = '';
				}
				?>
				<li class="mwb-about__list-item">
					<div class="mwb-about__list-item-text">
						<h3 class="mwb-about__list-item-heading">
							<?php echo esc_html( $feed_title ); ?>
						</h3>
						<p>  
							<span class="mwb-about__list-item-sub-heading">
								<?php esc_html_e( 'Active', 'integration-with-keap' ); ?>  
							</span>
							<span><input type="checkbox" feed_id="<?php echo esc_attr( $feed->ID ); ?>" class="mwb-crm-feed-switch" name="mwb_crm_feed_active" value="yes" <?php echo esc_attr( checked( $active, 'yes' ) ); ?> /></span>  
							
						</p>
						<p>
							<span class="mwb-about__list-item-sub-heading"> Object </span>
							<span><?php echo esc_html( $crm_object ); ?></span>   
						</p>
						<p>
							<span class="mwb-about__list-item-sub-heading"> Event </span>
							<span><?php echo esc_html( $feed_event_label ); ?></span> 
						</p>
						<?php if ( !empty( $lead_source ) ) { ?>
						<p>
							<span class="mwb-about__list-item-sub-heading"> Lead Source </span>
							<span><?php echo esc_html( $lead_source_label ); ?></span> 
						</p>
						<?php } ?>
						<p> 
							<span class="mwb-about__list-item-sub-heading"> Primary Field </span>
							<span><?php echo esc_html( $primary_field ); ?></span> 
						</p>
					</div>
					<div class="mwb-about__list-item-btn">
						<a class="mwb-edit-feed-btn"
							href="<?php echo esc_attr( $edit_link ); ?>">
							<img src="<?php echo esc_url( CRM_INTEGRATION_KEAP_URL ); ?>assets/src/images/edit.svg">
						</a>
						<?php if ( ! $default_feed ) : ?>
						<a class="mwb-delete-feed-btn"
							href="#" feed_id="<?php echo esc_attr( $feed->ID ); ?>">
							<img src="<?php echo esc_url( CRM_INTEGRATION_KEAP_URL ); ?>assets/src/images/trash.svg">
						</a>
						<?php endif; ?>
					</div>
				</li>
			<?php endforeach; ?>
		</ul>
		<div class="mwb-about__list-item mwb-about__list-add">            
			<div class="mwb-about__list-item-btn">
				<a href="<?php echo esc_url( admin_url( 'post-new.php?post_type=mwb_keap_feed' ) ); ?>" class="mwb-btn mwb-btn--filled"><?php esc_html_e( 'Add Feeds', 'integration-with-keap' ); ?></a>
			</div>
		</div>
</div>
