<?php
/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://wpswings.com/
 * @since      1.0.0
 *
 * @package    Integration_With_keap
 * @subpackage Integration_With_keap/admin/partials
 */

?>
<div id="mwb-data-sync" class="mwb-support mwb-content-wrap mwb-tabcontent">
	<div class="mwb-content__bottom-list-wrap">

		<div id="myProgress">
			<div id="myBar"></div>
			<p id="myBarText"></p>
		</div>

		<ul class="mwb-about__list mwb-bulk-data-center-wrap">
			<?php foreach ( $settings as $key => $attr ) : ?>
				<li class="mwb-about__list-item">
					<div class="mwb-about__list-item-text">
						<h3 class="mwb-about__list-item-heading">
							<?php
							echo esc_html(
								$attr['title'] ?
								$attr['title'] :
								false
							);
							?>
						</h3>
						<p>
							<?php
							echo esc_html(
								$attr['description'] ?
								$attr['description'] :
								false
							);
							?>
						</p>
					</div>
					<div class="mwb-about__list-item-btn">
						<a 
						<?php
						echo esc_attr(
							$attr['button']['newtab'] ?
							'target=_blank' :
							false
						);
						?>
						 
						href="
						<?php
						echo esc_attr(
							$attr['button']['href'] ?
							$attr['button']['href'] :
							'javascript:void(0);'
						);
						?>
						" class="mwb-sync-start" data-form="
						<?php
						echo esc_html(
							$attr['button']['class'] ?
							$attr['button']['class'] :
							''
						);
						?>
						">                     
							<img src="<?php echo esc_url( CRM_INTEGRATION_KEAP_URL ); ?>assets/src/images/down.svg">
						</a>                        
					</div>
					<div class="mwb-about__list-item-text mwb-hidden">
						<form class="mwb-sync-process-form form-<?php echo esc_html( $attr['button']['class'] ? $attr['button']['class'] : '' ); ?>" method="post">
							<?php
							$dependent_setting = array();

							$dependent_setting[] = array(
								'title'   => esc_html__(
									'Select Woo Object Type',
									'integration-with-keap'
								),
								'type'    => 'select',
								'options' => array(
									''    => esc_html__( 'No Options Selected', 'integration-with-keap' ),
									'Products'      => esc_html__( 'Products', 'integration-with-keap' ),
									'Contacts'      => esc_html__( 'Contacts', 'integration-with-keap' ),
									'Sales_Orders'  => esc_html__( 'Sales Orders', 'integration-with-keap' ),
								),
								'class'   => 'mwb-crm-select-sync-fields',
								'id'      => 'mwb-crm-select-woo-object',
								'value'   => '',
							);

							$dependent_setting[] = array(
								'title'   => esc_html__(
									'Select Feed',
									'integration-with-keap'
								),
								'type'    => 'select',
								'options' => array(
									''    => esc_html__( 'No Options Selected', 'integration-with-keap' ),
								),
								'class'   => 'mwb-crm-select-sync-fields',
								'id'      => 'mwb-crm-select-object-feed',
								'value'   => '',
							);
							?>
							<?php foreach ( $dependent_setting as $key => $setting ) : ?>
								<div class="mwb-sync-form__field">
									<?php woocommerce_admin_fields( array( $setting ) ); ?>
								</div>
							<?php endforeach; ?>
							<button class="mwb-btn mwb-btn--filled mwb-start-sync-action is_hidden"><?php esc_html_e( 'Start Sync', 'integration-with-keap' ); ?></button>
						</form>
						<div class="mwb-lists__progress">
							<?php $progress_id = 'bulk-data-sync' == $attr['button']['class'] ? 'BulkSync' : 'OneClickSync'; ?>
							<div id="mwb-lists__progress-bar-<?php echo esc_attr( $progress_id ); ?>" class="mwb-lists__progress-bar" role="progressbar" style="width: 1%;"></div>
						</div>
						<div class="mwb-sync-result">
							<span class="mwb-lists__progress-result"></span>
						</div>
					</div>
				</li>
			<?php endforeach; ?>
		</ul>
	</div>
</div>
