<?php
/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://wpswings.com/
 * @since      1.0.0
 *
 * @package    Integration_With_keap
 * @subpackage Integration_With_keap/admin/partials
 */

?>
<?php $keap_instance = Woo_Crm_Connect_Keap::get_instance(); ?>
<ul class="mwb-dashboard__about-list">
	<li class="mwb-dashboard__about-list-item mwb-content-wrap">
		<div class="mwb-content__list-item-text">
			<h2 class="mwb-section__heading">
				<?php esc_html_e( 'Contacts Synced', 'integration-with-keap' ); ?>
			</h2>
			<div class="mwb-dashboard__about-number">
				<span>
				<?php $keap_instance->getSyncedContactCount( 'Contacts' ); ?>
				</span>
			</div>
			<div class="mwb-dashboard__about-number-desc">
				<p>
					
				</p>
			</div>
		</div>
		<div class="mwb-content__list-item-image">
			<img src="<?php echo esc_url( CRM_INTEGRATION_KEAP_URL ); ?>assets/src/images/contact.svg" alt="">
		</div>
	</li>
	<li class="mwb-dashboard__about-list-item mwb-content-wrap">
		<div class="mwb-content__list-item-text">
			<h2 class="mwb-section__heading">
				<?php esc_html_e( 'Products Synced', 'integration-with-keap' ); ?>
			</h2>
			<div class="mwb-dashboard__about-number">
				<span>
				<?php $keap_instance->getSyncedObjectsCount( 'Products' ); ?>
				</span>
			</div>
			<div class="mwb-dashboard__about-number-desc">
				<p>
					
				</p>
			</div>
		</div>
		<div class="mwb-content__list-item-image">
			<img src="<?php echo esc_url( CRM_INTEGRATION_KEAP_URL ); ?>assets/src/images/contact.svg" alt="">
		</div>
	</li>

	<li class="mwb-dashboard__about-list-item  mwb-content-wrap">
		<div class="mwb-content__list-item-text ">
			<h2 class="mwb-section__heading">
				<?php esc_html_e( 'Orders Synced', 'integration-with-keap' ); ?>
			</h2>
			<div class="mwb-dashboard__about-number">
				<span>
				<?php $keap_instance->getSyncedObjectsCount( 'Sales_Orders' ); ?>
				</span>
			</div>
			<div class="mwb-dashboard__about-number-desc">
				<p>
					
				</p>
			</div>
		</div>
		<div class="mwb-content__list-item-image">
			<img src="<?php echo esc_url( CRM_INTEGRATION_KEAP_URL ); ?>assets/src/images/deals.svg" alt="">
		</div>
	</li>
</ul>
