<?php
/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://wpswings.com/
 * @since      1.0.0
 *
 * @package    Integration_With_keap
 * @subpackage Integration_With_keap/admin/partials
 */

?>

<div class="mwb-dashboard__header-content">

	<h3 class="mwb-section__sub-heading">

		<?php esc_html_e( 'KEAP Connection Status', 'integration-with-keap' ); ?>
	</h3>
	<div class="mwb-dashboard__header-text">
		<span class="<?php echo esc_attr( $connection_status ? 'is-connected' : 'disconnected' ); ?>" >
			<?php esc_html_e( 'Connected', 'integration-with-keap' ); ?>
		</span>
	</div>

	
	<span class="mwb-dashboard__header-arrow">
		
	</span>	
</div>
<div class="mwb-dashboard__header-button-wrap">	
	<div class="mwb-dashboard__header-button-text">
		<div class="mwb-dashboard__header-token-notice" id="mwb-keap-token-notice">
			<?php if ( ! $token_expiry ) : ?>
				<?php esc_html_e( 'Access token has been expired.', 'integration-with-keap' ); ?>
				<?php else : ?>
					<?php printf( 'Access token will expire in %2s hours %s minutes.', esc_attr( floor( $token_expiry / 60 ) ), esc_attr( ( (int) $token_expiry % 60 ) ) ); ?>
				<?php endif; ?>
		</div>
		<div class="mwb-dashboard__header-refresh-access-token-wrap">
			<a id="mwb-woo-keap-refresh-access-token">
				<img src="<?php echo esc_url( CRM_INTEGRATION_KEAP_URL ); ?>assets/src/images/refresh.svg">
				<span>Refresh Access Token</span>
			</a>
		</div>
	</div>
	<div class="mwb-dashboard__header-button">
		<a id="mwb-woo-keap-reauth" href="<?php echo esc_url( wp_nonce_url( admin_url( '?mwb_get_zoho_code=1' ) ) ); ?>" class="mwb-btn mwb-btn--filled">
				<?php esc_html_e( 'Reauthorize', 'integration-with-keap' ); ?>
		</a>
		<a id="mwb-woo-keap-disconnect" href="#" class="mwb-btn mwb-btn--filled">
				<?php esc_html_e( 'Disconnect', 'integration-with-keap' ); ?>
		</a>
	</div>
</div>
