<?php
/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://wpswings.com/
 * @since      1.0.0
 *
 * @package    Integration_With_keap
 */

?>
<div class="mwb-feeds__content  mwb-content-wrap mwb-feed__select-object">
	<a class="mwb-feeds__header-link active">
		<?php esc_html_e( 'Select Object', 'integration-with-keap' ); ?>
	</a>
	<div class="mwb-feeds__meta-box-main-wrapper">
		<div class="mwb-feeds__meta-box-wrap">
			<div class="mwb-form-wrapper">
				<select name="crm_object" id="mwb-feeds-keap-object" class="mwb-form__dropdown">
					<option value="-1"><?php esc_html_e( '--Select Object--', 'integration-with-keap' ); ?></option>
					<?php
					foreach ( $objects as $key => $object ) :
						?>
						<option value="<?php echo esc_attr( $object ); ?>" <?php echo esc_attr( selected( $selected_object, $object ) ); ?> >
							<?php echo esc_attr( $object ); ?>
						</option>
					<?php endforeach; ?>
				</select>
			</div>
			<div class="mwb-form-wrapper">
				<a id="mwb-woo-keap-refresh-object" class="mwb-btn mwb-btn--filled refresh-object"><?php esc_html_e( 'Refresh Objects', 'integration-with-keap' ); ?></a>
				<a id="mwb-woo-keap-refresh-fields" class="mwb-btn mwb-btn--filled refresh-fields"><?php esc_html_e( 'Refresh Fields', 'integration-with-keap' ); ?></a>
			</div>
		</div>
	</div>
</div>
