<?php
/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://wpswings.com/
 * @since      1.0.0
 *
 * @package    Integration_With_keap
 */

?>
<div id="mwb-shop-order-meta-box-wrap" >
	<div class="select-feed-wrap">
		<select id="mwb-keap-manual-sync-select" data-post-id ="<?php echo esc_html( $post_order_id ); ?>" style="margin: 10px 0px;" >
			<?php foreach ( $feeds as $key => $value ) : ?>
				<option value="<?php echo esc_attr( $key ); ?>">
					<?php echo esc_html( $value ); ?>
				</option>
			<?php endforeach; ?>
		</select>
		<a href="#" class="button" id="mwb-keap-manual-sync-button">
			<?php esc_html_e( 'Sync manually', 'integration-with-keap' ); ?>
		</a>
	</div>
</div>
<input type="hidden" name="meta_box_nonce" value="<?php echo esc_attr( wp_create_nonce( 'meta_box_nonce' ) ); ?>">
