<?php
/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the primary field of feeds section.
 *
 * @link       https://makewebbetter.com
 * @since      1.0.0
 *
 * @package    Mwb_Cf7_Integration_With_Mautic
 * @subpackage Mwb_Cf7_Integration_With_Mautic/mwb-crm-fw/templates/meta-boxes
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$prefilled_indexes = 1;
if ( is_array($condition) ) {
	$prefilled_indexes = isset( $condition ) ? count( $condition ) : '';
}

?>
<div id="mwb-condition-filter-section-wrapper"  class="mwb-feeds__content  mwb-content-wrap">
	<a class="mwb-feeds__header-link">
		<?php esc_html_e( 'Condition Filter', 'integration-with-quickbooks' ); ?>
	</a>

	<div class="mwb-feeds__meta-box-main-wrapper">
		<div class="mwb-feeds__meta-box-wrap">
			<div class="mwb-form-wrapper  mwb-form-filter-wrapper">
				<div class="mwb-initial-filter">
					<?php if ( ! empty( $condition ) && is_array( $condition ) ) : ?>
						<?php foreach ( $condition as $or_index => $and_conditions ) : ?>
							<div class="or-condition-filter" data-or-index="<?php echo esc_html( $or_index ); ?>">
								<div class="mwb-form-filter-row">
									<?php foreach ( $and_conditions as $and_index => $and_condition ) : ?>
										<?php
										$and_condition['form_fields'] = $crm_fields['fields'];
										$template_manager      = new Crm_Integration_Connect_Framework_Keap();
										$template_manager->render_and_conditon( $and_condition, $and_index, $or_index );
										?>
									<?php endforeach; ?>
									<button data-next-and-index="<?php echo esc_html( ++$and_index ); ?>" data-or-index="<?php echo esc_html( $or_index ); ?>" class="button condition-and-btn"><?php esc_html_e( 'Add "AND" filter', 'integration-with-quickbooks' ); ?></button>
									<?php if ( 1 != $prefilled_indexes ) :  // phpcs:ignore ?>
										<img src="<?php echo esc_url( CRM_INTEGRATION_KEAP_URL . 'assets/src/images/trash.svg' ); ?>" id="feed_section_trash_icon" class="dashicons-trash" alt="<?php esc_html_e( 'Trash', 'integration-with-quickbooks' ); ?>">
									<?php endif; ?>
								</div>
							</div>
						<?php endforeach; ?>
					<?php endif; ?>
					<button data-next-or-index="<?php echo esc_html( ++$prefilled_indexes ); ?>" class="button condition-or-btn"><?php esc_html_e( 'Add "OR" filter', 'integration-with-quickbooks' ); ?></button>
				</div>
			</div>
		</div>
	</div>
</div>


