<?php
/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://wpswings.com/
 * @since      1.0.0
 *
 * @package    Integration_With_keap
 */

?>
<div id="mwb-lead-source-section-wrapper"  class="mwb-feeds__content  mwb-content-wrap row-hide">
	<a class="mwb-feeds__header-link">
		<?php esc_html_e( 'Lead Soruce', 'integration-with-keap' ); ?>
	</a>
	<div class="mwb-feeds__meta-box-main-wrapper">
		<div class="mwb-feeds__meta-box-wrap">
			<div class="mwb-form-wrapper">
				<label for="lead_source"><?php esc_html_e( 'Assign lead source to a contact', 'integration-with-keap' ); ?></label>
				<select id="select-lead-source" name="lead_source">
					<?php foreach ( $lead_source_options as $key => $value ) : ?>
						<option  <?php echo esc_attr( selected( $key, $lead_source ) ); ?> value="<?php echo esc_attr( $key ); ?>" >
							<?php echo esc_attr( $value ); ?>
						</option>
					<?php endforeach; ?>
				</select>
			</div>
		</div>
	</div>
</div>
