<?php
/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://wpswings.com/
 * @since      1.0.0
 *
 * @package    Integration_With_keap
 * @subpackage Integration_With_keap/includes
 */

if ( ! class_exists( 'Crm_Integration_Connect_Framework_Keap' ) ) {
	wp_die( 'Crm_Integration_Connect_Framework_Keap does not exists.' );
}

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Integration_With_keap
 * @subpackage Integration_With_keap/includes
 */
use Automattic\WooCommerce\Utilities\OrderUtil;
class Woo_Crm_Connect_Keap extends Crm_Integration_Connect_Framework_Keap {

	/**
	 *  The instance of this class.
	 *
	 * @since    1.0.0
	 * @var      string    $instance    The instance of this class.
	 */
	private static $instance;

	/**
	 * Main Woo_Crm_Connect_Keap Instance.
	 *
	 * Ensures only one instance of Woo_Crm_Connect_Keap is loaded or can be loaded.
	 *
	 * @since 1.0.0
	 * @static
	 * @return Woo_Crm_Connect_Keap - Main instance.
	 */
	public static function get_instance() {

		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Get current mapping scenerio for current CRM connection.
	 *
	 * @since 1.0.0
	 *
	 * @return array - Current CRM to Woo mapping.
	 */
	public function getMappingDataset() {

		$obj_type = array(
			'shop_order',
			'product',
			'users',
		);

		$formatted_dataset = array();

		foreach ( $obj_type as $key => $obj ) {
			$formatted_dataset[ $obj ] = $this->getMappingOptions( $obj );
		}

		return $this->parseLabels( $formatted_dataset );
	}

	/**
	 * Get current mapping scenerio for current CRM connection.
	 *
	 * @param string $obj_type - Woo Object type to get mapping for.
	 *
	 * @since 1.0.0
	 *
	 * @return array - Current CRM to Woo mapping.
	 */
	public function getMappingOptions( $obj_type = false ) {

		$meta_data = $this->get_wp_meta( $obj_type );

		return $meta_data;
	}

	/**
	 * Returns the mapped objects counts.
	 *
	 * @param string $obj_type The Object post type.
	 *
	 * @since 1.0.0
	 *
	 */
	public function getSyncedObjectsCount( $obj_type = false ) {
		
		if ( empty( $obj_type ) ) {
			return;
		}
		
		$feed_ids = $this->getObjectFeed( $obj_type );
		
		if ( ! empty( $feed_ids ) ) {

			global $wpdb;

			if ( OrderUtil::custom_orders_table_usage_is_enabled() ) {
				if ( 'Sales_Orders' == $obj_type ) {
					$wc_orders_meta = $wpdb->prefix . 'wc_orders_meta';
					$sql = "SELECT COUNT(*) FROM {$wc_orders_meta} WHERE ";
				} else {
					$post_meta = $wpdb->prefix . 'postmeta';
					$sql = "SELECT COUNT(*) FROM {$post_meta} WHERE ";
				}
			} else {
				$post_meta = $wpdb->prefix . 'postmeta';
				$sql = "SELECT COUNT(*) FROM {$post_meta} WHERE ";
			}

			if ( is_array( $feed_ids ) ) {

				$feed_query = '';
				foreach ( $feed_ids as $key => $feed_id ) {
					if ( empty( $feed_query ) ) {
						$feed_query = "`meta_key` =  'mwb_keap_feed_" . $feed_id . "_association'";
					} else {
						$feed_query .= " OR `meta_key` = 'mwb_keap_feed_" . $feed_id . "_association'";
					}
				}
			} else {
				$feed_query = "`meta_key` =  'mwb_keap_feed_" . $feed_ids . "_association'";
			}

			$sql .= $feed_query;
			$sql .= 'AND `meta_value` IS NOT NULL';
		}
		if ( ! empty( $sql ) ) {

			$result = mwb_woo_keap_get_query_results( $sql );
		}

		$count = ! empty( $result[0]['COUNT(*)'] ) ? $result[0]['COUNT(*)'] : 0;
		echo esc_html( $count );
	}

	/**
	 * Returns the mapped objects counts.
	 *
	 * @param string $obj_type The Object post type.
	 *
	 * @since 1.0.0
	 *
	 */
	public function getSyncedContactCount( $obj_type = false ) {
		
		if ( empty( $obj_type ) ) {
			return;
		}
		
		$feed_ids = $this->getObjectFeed( $obj_type );
		
		if ( ! empty( $feed_ids ) ) {

			global $wpdb;

			if ( OrderUtil::custom_orders_table_usage_is_enabled() ) {
				$wc_orders_meta = $wpdb->prefix . 'wc_orders_meta';
				$sql = "SELECT COUNT( DISTINCT `meta_value`) FROM `{$wc_orders_meta}` WHERE";
			} else {
				$post_meta = $wpdb->prefix . 'postmeta';
				$sql = "SELECT COUNT( DISTINCT `meta_value`) FROM `{$post_meta}` WHERE";
			}

			if ( is_array( $feed_ids ) ) {

				$feed_query = '';
				foreach ( $feed_ids as $key => $feed_id ) {
					if ( empty( $feed_query ) ) {
						
						$feed_query = "`meta_key` =  'mwb_keap_feed_" . $feed_id . "_association'";
					} else {
						
						$feed_query .= " OR `meta_key` = 'mwb_keap_feed_" . $feed_id . "_association'";
					}

				}
			} else {
				
				$feed_query = "`meta_key` =  'mwb_keap_feed_" . $feed_ids . "_association'";
			}
			
			$sql .= $feed_query;
			
		}
		if ( ! empty( $sql ) ) {

			$result = mwb_woo_keap_get_query_results( $sql );
		}

		$count = ! empty( $result[0]['COUNT( DISTINCT `meta_value`)'] ) ? $result[0]['COUNT( DISTINCT `meta_value`)'] : 0;

		echo esc_html( $count );
	}

	// End of class.
}
