<?php
/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://wpswings.com/
 * @since      1.0.0
 *
 * @package    Integration_With_keap
 * @subpackage Integration_With_keap/admin/partials
 */

?>

<div class="mwb-progress__wrap">
	<div class="mwb-progress">
	  <div class="mwb-progress__bar step-1 active">.</div>
  </div>
  <div class="mwb-progress__step-wrap">
	<div class="mwb-progress__step">

	</div>
	<div class="mwb-progress__step">
		<?php esc_html_e( 'Setup Connection', 'integration-with-keap' ); ?>
	</div>
	<div class="mwb-progress__step">
		<?php esc_html_e( 'Create Feeds', 'integration-with-keap' ); ?>
	</div>
	<div class="mwb-progress__step">
		<?php esc_html_e( 'Create Tags', 'integration-with-keap' ); ?>
	</div>
	<div class="mwb-progress__step">
		<?php esc_html_e( 'Sync Data', 'integration-with-keap' ); ?>
	</div>
	<div class="mwb-progress__step">
		<?php esc_html_e( 'Completed', 'integration-with-keap' ); ?>
	</div>
</div>
</div>
<section class="mwb-intro">
	<div class="mwb-content-wrap">
		<div class="mwb-intro__header">
			<h2 class="mwb-section__heading">
				<?php
				echo esc_html__( 'Getting started with Keap and WooCommerce' );
				?>
			</h2>
		</div>
		<?php if ( ! get_option( 'mwb-woo-keap-authorised', false ) ) : ?>
		<div class="mwb-intro__body mwb-intro__content">
			<p>
				<?php
				esc_html_e(
					'With this WooCommerce Keap Integration you can easily sync all your WooCommerce data over Keap CRM. It will create Contacts and Sales Orders over Keap CRM, based on your WooCommerce Order data.
                    It will also create Products over Keap CRM and map them with Sales Order.',
					'integration-with-keap'
				);
				?>
				 
			 </p>
			<ul class="mwb-intro__list">
				<li class="mwb-intro__list-item">
					<?php esc_html_e( 'Connect your Keap CRM account with WooCommerce.', 'integration-with-keap' ); ?>
				</li>
				<li class="mwb-intro__list-item">
				<?php esc_html_e( 'Create feeds for your Contacts, Products and Orders.', 'integration-with-keap' ); ?>
				</li>
				<li class="mwb-intro__list-item">
				<?php esc_html_e( 'Sync your data over Keap CRM.', 'integration-with-keap' ); ?>
				</li>
			</ul>
			<div class="mwb-intro__button">
				<a href="#" class="mwb-btn mwb-btn--filled" onclick="showAuthForm( event )">
					<?php
					esc_html_e(
						'Connect your Account.',
						'
                    integration-with-keap'
					);
					?>
				</a>
			</div>
		</div>  
		<div class="mwb-intro__body mwb-keap-auth-wrap section-hide">
			<?php
			$settings = Crm_Integration_For_Keap_Admin::get_keap_authorization_settings();
			?>
			<form action="#" method="post" id="mwb-keap-auth-portal">
				<?php woocommerce_admin_fields( $settings ); ?>
				<?php wp_nonce_field( 'admin_save_data', 'mwb_tabs_nonce' ); ?>
			</form>
			<div class="mwb-intro__button">
				<a href="javascript:void(0)" class="mwb-btn mwb-btn--filled" id="mwb-keap-authorize-button" >
					<?php esc_html_e( 'Authorize', 'integration-with-keap' ); ?>
				</a>
				<div class="mwb-intro__bottom-text-wrap">
					<p>
					<?php
					esc_html_e(
						'Don’t have an account yet.',
						'
                    integration-with-keap'
					);
					?>
						<a href="https://developer.infusionsoft.com/get-started/" target="_blank" class="mwb-btn__bottom-text"><?php esc_html_e( 'Create A Free Account', 'integration-with-keap' ); ?></a></p>
					<p>
					<?php
					esc_html_e(
						'Get Your Client/Secret Id here.',
						'
                    integration-with-keap'
					);
					?>
						<a href="https://keys.developer.keap.com/" target="_blank" class="mwb-btn__bottom-text"><?php esc_html_e( 'Get Api Keys', 'integration-with-keap' ); ?></a></p>
					<p>
					<?php
					esc_html_e(
						'Check app setup guide.',
						'
                    integration-with-keap'
					);
					?>
						<a href="https://docs.woocommerce.com/document/integration-with-keap/" target="_blank" class="mwb-btn__bottom-text"><?php esc_html_e( 'Check Now', 'integration-with-keap' ); ?></a></p>
				</div>
			</div>
		</div>
		<?php else : ?>
		<div class="mwb-intro__body mwb-zoho-auth-success">
			<p> <?php esc_html_e( 'Authentication has been success full move to next step', 'integration-with-keap' ); ?> </p>
			<div class="mwb-intro__button">
				<a href="#" class="mwb-btn mwb-btn--filled progress-next show-properties-btn">
					<?php esc_html_e( 'Move to next step', 'integration-with-keap' ); ?>
				</a>
			</div>
		</div>
		<?php endif; ?>
	</div>
</section>

<section class="mwb-properties">
	<div class="mwb-content-wrap">
		<div class="mwb-properties__header">
			<h2 class="mwb-section__heading">
				<?php esc_html_e( 'Create Feeds', 'integration-with-keap' ); ?>
			</h2>
		</div>
		<div class="mwb-properties__body mwb-properties__content">
			<p>
				<?php
				esc_html_e( 'As you have successfuly connected your WooCommerce to Keap CRM. Next you will need to create some feeds. Feeds are mapping rules, according to which data is being mapped and sent over Keap CRM.', 'integration-with-keap' );
				?>
			</p>
			<p>
				<?php
				esc_html_e( 'We create three default feeds to send WooCommerce data over Keap CRM.', 'integration-with-keap' );
				?>
			</p>
			<ul class="mwb-properties__list">
				<li class="mwb-properties__list-item">
					<?php esc_html_e( 'Default Contacts Feed', 'integration-with-keap' ); ?>
				</li>
				<li class="mwb-properties__list-item">
					<?php esc_html_e( 'Default Products Feed', 'integration-with-keap' ); ?>
				</li>
			  
				<li class="mwb-properties__list-item">
					<?php esc_html_e( 'Default Orders Feed', 'integration-with-keap' ); ?> 
				</li>
			</ul>
			<div class="mwb-properties__progress-button">
				<a href="#" class="mwb-btn mwb-btn--filled show-intro-progress">
					<?php esc_html_e( 'Create Feeds', 'integration-with-keap' ); ?>
				</a>
			</div>
			<div class="mwb-properties__progress">
				<div id="mwb-properties__progress-bar" class="mwb-properties__progress-bar" role="progressbar"></div>
			</div>
			<div class="mwb-properties__button">
				<a href="#" class="mwb-btn mwb-btn--filled progress-next show-tags">
					<?php esc_html_e( 'Move to next step', 'integration-with-keap' ); ?>
				</a>
			</div>
		</div>         
	</div>
</section>

<section class="mwb-tags">
	<div class="mwb-content-wrap">
		<div class="mwb-tags__header">
			<h2 class="mwb-section__heading">
				<?php esc_html_e( 'Create Tags Categories ', 'integration-with-keap' ); ?>
			</h2>
		</div>
		<div class="mwb-tags__body mwb-tags__content">
			<p>
				<?php
				esc_html_e( 'As you have successfuly connected your WooCommerce to Keap CRM. Next you will need to create some Tag Categories.', 'integration-with-keap' );
				?>
			</p>
			<p>
				<?php
				esc_html_e( 'We create One default Tag Category to send WooCommerce Products name, Products SKUs, Products Type, Customer/User Role data as a tag over Keap CRM.', 'integration-with-keap' );
				?>
			</p>
			<ul class="mwb-tags__list">
				<li class="mwb-tags__list-item">
					<?php esc_html_e( 'Default Tag categories & Tags', 'integration-with-keap' ); ?>
				</li>
			</ul>
			<div class="mwb-tags__progress-button">
				<a href="#" class="mwb-btn mwb-btn--filled create-tags-category">
					<?php esc_html_e( 'Create Category', 'integration-with-keap' ); ?>
				</a>
			</div>
			<div class="mwb-tags__progress">
				<div id="mwb-tags__progress-bar" class="mwb-tags__progress-bar" role="progressbar"></div>
			</div>
			<div class="mwb-tags__button">
				<a href="#" class="mwb-btn mwb-btn--filled progress-next show-lists">
					<?php esc_html_e( 'Move to next step', 'integration-with-keap' ); ?>
				</a>
			</div>
		</div>         
	</div>
</section>

<section class="mwb-lists">
	<div class="mwb-content-wrap">
		<div class="mwb-lists__header">
			<h2 class="mwb-section__heading">
				<?php esc_html_e( 'Sync your existing data to Keap CRM', 'integration-with-keap' ); ?>
			</h2>
		</div>
		<div class="mwb-lists__body mwb-lists__content-wrap">
			<p>
				<input type="hidden" class="mwb-keap-product-count" value="<?php echo esc_html( mwb_woo_keap_get_total_product_count() ); ?>">
				<input type="hidden" class="mwb-keap-shop-order-count" value="<?php echo esc_html( mwb_woo_keap_get_total_shop_order_count() ); ?>">
				<?php esc_html_e( 'You are all set to sync your WooCommerce data over Keap CRM', 'integration-with-keap' ); ?>
			</p>
			<p>
				<?php esc_html_e( 'You can sync all the historical data of your WooCommerce store in this step.', 'integration-with-keap' ); ?>
			</p>
			<p>
				<?php esc_html_e( 'This step may take some time depending on the number of Products, Contacts and Orders in your site.', 'integration-with-keap' ); ?>
			</p>
			<p>
				<?php esc_html_e( 'You can skip this step and complete the setup process. You can sync the data any time using Bulk Sync Feature of Integration.', 'integration-with-keap' ); ?>
			</p>
			<div class="mwb-lists__content mwb-lists-sync-data mwb-lists-Products-sync">            
				<p> <?php esc_html_e( 'Syncing your WooCommerce products including variations over Keap Crm', 'integration-with-keap' ); ?> </p>          
				<div class="mwb-lists__progress">
					<div id="mwb-lists__progress-bar-Products" class="mwb-lists__progress-bar" role="progressbar"></div>
				</div>
				<div class="mwb-sync-result" id="mwb-lists__progress-bar-Products-result">
					<span class="mwb-lists__progress-result"></span>
				</div>
			</div>  
			<div class="mwb-lists__content mwb-lists-sync-data mwb-lists-Contacts-sync">            
				<p> <?php esc_html_e( 'Syncing your WooCommerce customer data over Keap CRM as Contacts', 'integration-with-keap' ); ?> </p>            
				<div class="mwb-lists__progress">
					<div id="mwb-lists__progress-bar-Contacts" class="mwb-lists__progress-bar" role="progressbar"></div>
				</div>
				<div class="mwb-sync-result" id="mwb-lists__progress-bar-Contacts-result">
					<span class="mwb-lists__progress-result"></span>
				</div>
			</div> 

			<div class="mwb-lists__content mwb-lists-sync-data mwb-lists-Sales_Orders-sync">            
				<p> <?php esc_html_e( 'Creating sales order over Keap from your WooCommerce Orders', 'integration-with-keap' ); ?> </p>         
				<div class="mwb-lists__progress">
					<div id="mwb-lists__progress-bar-Sales_Orders" class="mwb-lists__progress-bar" role="progressbar"></div>
				</div>
				<div class="mwb-sync-result" id="mwb-lists__progress-bar-Sales_Orders-result">
					<span class="mwb-lists__progress-result"></span>
				</div>
			</div> 
			<div class="mwb-lists__button">
				<a id="mwb-start-initial-sync" href="#" class="mwb-btn mwb-btn--filled mwb-lists__button-start hide-start">
					<?php esc_html_e( 'Start Sync', 'integration-with-keap' ); ?>
				</a>
				<a id="sync_later" href="javascript:void(0)" class="mwb-btn mwb-btn--filled progress-next active ">
					<?php esc_html_e( 'Skip For Now', 'integration-with-keap' ); ?>
				</a>
				<a href="#" class="mwb-btn mwb-btn--filled progress-next show-sync">
					<?php esc_html_e( 'Next', 'integration-with-keap' ); ?>
				</a>
			</div>
		</div>       
	</div>
</section>

<section class="mwb-sync">
	<div class="mwb-content-wrap">
		<div class="mwb-sync__header">
			<h2 class="mwb-section__heading">
				<?php
				esc_html_e( 'Congrats! You’ve successfully set up the  Keap Integration for WooCommerce Plugin.', 'integration-with-keap' );
				?>
			</h2>
		</div>
		<div class="mwb-sync__body mwb-sync__content-wrap">            
			<div class="mwb-sync__image">    
				<img src="<?php echo esc_url( CRM_INTEGRATION_KEAP_URL ); ?>assets/src/images/congo.jpg">
			</div>       
			<div class="mwb-sync__content">            
				<p> 
					<?php
					esc_html_e( 'Now you can go to the dashboard and check for the synced data. You can check your feeds, edit them and resync the data if you want. If you do not see your data over Keap CRM, you can check the logs for any possible error.', 'integration-with-keap' );
					?>
				</p>
				<div class="mwb-sync__button">
					<a href="#" class="mwb-btn mwb-btn--filled mwb-onboarding-complete" onclick="">
						<?php esc_html_e( 'View Dashboard', 'integration-with-keap' ); ?>
					</a>
				</div>
			</div>             
		</div>       
	</div>
</section>
