<?php
/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://wpswings.com/
 * @since      1.0.0
 *
 * @package    Integration_With_keap
 * @subpackage Integration_With_keap/admin/partials
 */

?>
<div id="myModal" class="modal">
  <div class="modal-content">
	<span class="closeClearLogPopup">&times;</span>
	<p>Are you sure you want to delete this item?</p>
	<button id="confirmDelete" class="button button-primary">Delete</button>
  </div>
</div>
<?php $log_enable = Crm_Integration_For_Keap_Admin::is_log_enable(); ?>
<div id="mwb-logs" class="mwb-content-wrap mwb-tabcontent" ajax_url="<?php echo esc_attr( admin_url( 'admin-ajax.php' ) ); ?>" >
	<div class="mwb-logs__header">
		<div class="mwb-logs__heading-wrap">
			<h2 class="mwb-section__heading">
				<?php esc_html_e( 'Sync Log', 'integration-with-keap' ); ?>	
			</h2>
		</div>
		<?php if ( $log_enable ) : ?>
		<ul class="mwb-logs__settings-list">
			<li class="mwb-logs__settings-list-item">
				<p>Filter based on Keap objects: </p>
			</li>
			<li class="mwb-logs__settings-list-item">
				<select id="filter_woo_obj">
					<option>--Select Keap Object--</option>
					<option value="Contacts">Contacts</option>
					<option value="Sales_Orders">Sales_Orders</option>
					<option value="Products">Products</option>
				</select>
			</li>
			<li class="mwb-logs__settings-list-item">
				<a id="mwb-woo-keap-clear-log" href="#" class="mwb-logs__setting-link">
					<?php esc_html_e( 'Clear Log', 'integration-with-keap' ); ?>	
				</a>
			</li>
			<li class="mwb-logs__settings-list-item">
				<a id="mwb-woo-keap-download-log" class="mwb-logs__setting-link">
					<?php esc_html_e( 'Download', 'integration-with-keap' ); ?>	
				</a>
			</li>
		</ul>
		<?php endif; ?>
	</div>
	<?php if ( $log_enable ) : ?>
	<div class="mwb-table__wrapper">
		<table id="mwb-table" width="100%" class="mwb-table dt-responsive">
			<thead>
				<tr>
					<th><?php esc_html_e( 'Expand', 'integration-with-keap' ); ?></th>
					<th><?php esc_html_e( 'Feed', 'integration-with-keap' ); ?></th>
					<th><?php esc_html_e( 'Woo Object', 'integration-with-keap' ); ?></th>
					<th><?php esc_html_e( 'Woo Object Id', 'integration-with-keap' ); ?></th>
					<th><?php esc_html_e( 'Keap Object', 'integration-with-keap' ); ?></th>
					<th><?php esc_html_e( 'Keap Object Id', 'integration-with-keap' ); ?></th>
					<th><?php esc_html_e( 'Time', 'integration-with-keap' ); ?></th>
					<th><?php esc_html_e( 'Request', 'integration-with-keap' ); ?></th>
					<th><?php esc_html_e( 'Response', 'integration-with-keap' ); ?></th>
				</tr>
			</thead>
		</table>
	</div>
	<?php else : ?>
	<div class="mwb-content-wrap">
		<?php esc_html_e( 'Please enable the log', 'integration-with-keap' ); ?>
	</div>
	<?php endif; ?>
</div>
