<?php
/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://wpswings.com/
 * @since      1.0.0
 *
 * @package    Integration_With_keap
 */

?>
<div id="mwb-feed-event-section-wrapper"  class="mwb-feeds__content  mwb-content-wrap row-hide">
	<a class="mwb-feeds__header-link">
		<?php esc_html_e( 'Select Event', 'integration-with-keap' ); ?>
	</a>
	<div class="mwb-feeds__meta-box-main-wrapper">
		<div class="mwb-feeds__meta-box-wrap">
			<div class="mwb-form-wrapper">
				<label for="primary_field"><?php esc_html_e( 'Select Event', 'integration-with-keap' ); ?></label>
				<select id="select-feed-event" name="feed_event">
					<?php foreach ( $feed_event_options as $key => $value ) : ?>
						<option  <?php echo esc_attr( selected( $key, $feed_event ) ); ?> value="<?php echo esc_attr( $key ); ?>" >
							<?php echo esc_attr( $value ); ?>
						</option>
					<?php endforeach; ?>
				</select>
			</div>
		</div>
	</div>
</div>
