<?php
/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://wpswings.com/
 * @since      1.0.0
 *
 * @package    Integration_With_keap
 */

?>
<div id="mwb-primary-field-section-wrapper"  class="mwb-feeds__content  mwb-content-wrap row-hide">
	<a class="mwb-feeds__header-link">
		<?php esc_html_e( 'Primary Field', 'integration-with-keap' ); ?>
	</a>
	<div class="mwb-feeds__meta-box-main-wrapper">
		<div class="mwb-feeds__meta-box-wrap">
			<div class="mwb-form-wrapper">
				<label for="primary_field"><?php esc_html_e( 'Select Primary Field', 'integration-with-keap' ); ?></label>
				<select id="primary-field-select" name="primary_field" primary_field="<?php echo esc_attr( $primary_field ); ?>" ></select>
				<p class="mwb-description">
					<?php
						esc_html_e( 'Please select a field which should be used as "primary key" to update an existing record.', 'integration-with-keap' );
					?>
				</p>
				<p class="mwb-description">
					<?php
						esc_html_e( 'Make sure "Do not allow duplicate values" is checked in property settings, in order to prevent duplicate record creation.', 'integration-with-keap' );
					?>
				</p>
			</div>
		</div>
	</div>
</div>
