<?php
/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://wpswings.com/
 * @since      1.0.0
 *
 * @package    Integration_With_keap
 */

?>
<div id="mwb-order-status-mapping-section-wrapper"  class="mwb-feeds__content  mwb-content-wrap row-hide" order_statuses="<?php echo esc_attr( htmlspecialchars( wp_json_encode( $woo_statuses ), ENT_QUOTES, 'UTF-8' ) ); ?>" status_mapping="<?php echo esc_attr( htmlspecialchars( wp_json_encode( $status_mapping ), ENT_QUOTES, 'UTF-8' ) ); ?>" >
	<a class="mwb-feeds__header-link">
		<?php esc_html_e( 'Map Woo Order Statuses', 'integration-with-keap' ); ?>
	</a>
	<div class="mwb-feeds__meta-box-main-wrapper">
		<div class="mwb-feeds__meta-box-wrap">
			<div class="mwb-form-wrapper">
				<table id="woo-status-table" class="mwb-form-table">
					<?php foreach ( $woo_statuses as $key => $value ) : ?>
						<tr class="woo-status-row">
							<td>
								<label><?php echo esc_attr( $value ); ?></label>
								<input type="hidden" name="woo_status[]" value="<?php echo esc_attr( $key ); ?>" class="woo-status" ></td>
							<td>
								<select class="crm-status-mapping-select" name="crm_picklist_value[]">
								</select>
							</td>
							<td></td>
						</tr>
					<?php endforeach; ?>
				</table>
			</div>
		</div>
	</div>
</div>
