<?php
/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://wpswings.com/
 * @since      1.0.0
 *
 * @package    Integration_With_keap
 * @subpackage Integration_With_keap/admin/partials
 */

?>

<?php

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}
?>

<?php if ( ! empty( $tabs ) && is_array( $tabs ) ) : ?>
<div class="mwb-tab__header mwb-content-wrap">
	<ul class="mwb-tab__header-list">
		<?php foreach ( $tabs as $key => $label ) : ?>
			<li class="mwb-tab__header-list-item">
				<?php $is_active = 'mwb-dashboard' == $key ? 'active' : ''; ?>
				<button class="mwb-tab-link <?php echo esc_html( $key ); ?>-tab-link <?php echo esc_html( $is_active ); ?>" onclick="opentab( event, '<?php echo esc_html( $key ); ?>')"><?php echo esc_html( $label ); ?></button>
			</li>
		<?php endforeach; ?>
	</ul>
</div>
<?php endif; ?>
