<?php
/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://wpswings.com/
 * @since      1.0.0
 *
 * @package    Integration_With_keap
 * @subpackage Integration_With_keap/includes
 */

if ( ! class_exists( 'Crm_Integration_Connect_Framework_Keap' ) ) {
	wp_die( 'Crm_Integration_Connect_Framework_Keap does not exists.' );
}

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Integration_With_keap
 * @subpackage Integration_With_keap/includes
 */
use Automattic\WooCommerce\Internal\DataStores\Orders\CustomOrdersTableController;
use Automattic\WooCommerce\Utilities\OrderUtil;
class Crm_Integration_For_Keap_Cpt {


	 /**
	  *  The slug prefix for this crm.
	  *
	  * @since    1.0.0
	  * @var      string    $crm_prefix    The crm prefix of this class.
	  */
	 private $crm_prefix;


	/**
	 * Define the core functionality of the plugin.
	 *
	 * Set the plugin name and the plugin version that can be used throughout the plugin.
	 * Load the dependencies, define the locale, and set the hooks for the admin area and
	 * the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function __construct() {

		$this->crm_prefix = 'keap';
	}

	/**
	 * Register custom post types
	 */
	public function register_plugin_cpt() {

		// Set UI labels for Custom Post Type.
		$labels = array(
			'name'                => _x( 'Feeds', 'Post Type General Name', 'integration-with-keap' ),
			'singular_name'       => _x( 'Feed', 'Post Type Singular Name', 'integration-with-keap' ),
			'menu_name'             => _x( 'Crm Feeds', 'Admin menu name', 'integration-with-keap' ),
			'parent_item_colon'   => __( 'Parent Feed', 'integration-with-keap' ),
			'all_items'           => __( 'All Feeds', 'integration-with-keap' ),
			'view_item'           => __( 'View Feed', 'integration-with-keap' ),
			'add_new_item'        => __( 'Add New Feed', 'integration-with-keap' ),
			'add_new'             => __( 'Add New', 'integration-with-keap' ),
			'edit_item'           => __( 'Edit Feed', 'integration-with-keap' ),
			'update_item'         => __( 'Update Feed', 'integration-with-keap' ),
			'search_items'        => __( 'Search Feed', 'integration-with-keap' ),
			'not_found'           => __( 'Not Found', 'integration-with-keap' ),
			'not_found_in_trash'  => __( 'Not found in Trash', 'integration-with-keap' ),
		);

		$args = array(
			'label'               => __( 'Feeds', 'integration-with-keap' ),
			'description'         => __( 'Feeds for crm', 'integration-with-keap' ),
			'labels'              => $labels,
			'supports'            => array( 'title' ),
			'hierarchical'        => false,
			'public'              => true,
			'menu_position'       => 5,
			'can_export'          => true,
			'has_archive'         => true,
			'show_in_rest'        => false,
			'exclude_from_search' => false,
			'publicly_queryable'  => false,
			'show_in_menu'        => false,
			'show_in_nav_menus'   => false,
			'show_in_admin_bar'   => false,
		);
		register_post_type( 'mwb_keap_feed', $args );
	}

	/**
	 * Add meta boxes for feeds
	 */
	public function add_feed_meta_boxes() {

		$shop_order_screen = wc_get_container()->get( CustomOrdersTableController::class )->custom_orders_table_usage_is_enabled()
		? wc_get_page_screen_id( 'shop-order' )
		: 'shop_order';

		add_meta_box(
			'crm-feed-meta-box',
			__( 'Feed Details', 'integration-with-keap' ),
			array( $this, 'crm_feed_meta_box_data' ),
			'mwb_keap_feed',
			'normal',
			'default'
		);

		add_meta_box(
			'mwb-keap-meta-box',
			__( 'Keap Feeds', 'integration-with-keap' ),
			array( $this, 'shop_order_meta_box_data' ),
			$shop_order_screen,
			'side',
			'low'
		);

		add_meta_box(
			'crm-object-ids-meta-box',
			sprintf( '%s %s', 'Keap', esc_html__( 'Feeds', 'integration-with-quickbooks' ) ),
			array( $this, 'shop_order_quickbooks_feed_meta_box' ),
			$shop_order_screen,
			'side',
			'low'
		);

		add_meta_box(
			'crm-object-ids-meta-box',
			sprintf( '%s %s', 'Keap', esc_html__( 'Feeds', 'integration-with-quickbooks' ) ),
			array( $this, 'shop_order_quickbooks_feed_meta_box' ),
			'product',
			'side',
			'low'
		);
	}

	/**
	 * Add shop order feeds meta box.
	 */
	public function shop_order_quickbooks_feed_meta_box( $post_or_order_object ) {

		if ( OrderUtil::custom_orders_table_usage_is_enabled() ) {

			if ( isset( $post_or_order_object->post_type ) ) {
				$item_type     = ( 'product' === $post_or_order_object->post_type ) ? 'Product id' : 'Order id';
			} else {
				$item_type     = 'Order id';
			}
			$feed_list     = array();
			$feeds         = $this->get_available_feeds_for_mapping();
			$variation_ids = array();
			if ( isset( $post_or_order_object->post_type ) ) {
				$o_id = '';
				$p_id = $post_or_order_object->ID;
			} else {
				$o_id = $post_or_order_object->get_id();
				$p_id = '';
			}
			if ( empty( $o_id ) && !empty( $p_id ) ) {
				$object_type = wps_get_object_type($post_or_order_object->ID);
				$product = wc_get_product( $post_or_order_object->ID );
				$prod_type = $product->get_type();
				$availble_variations = array();
				$item_type     = ( 'product' === $post_or_order_object->post_type ) ? 'Product id' : 'Order id';
	
				if ( count( $feeds ) ) {
					foreach ( $feeds as $feed_id => $feed_title ) {
						$crm_object = $this->get_feed_data( $feed_id, 'crm_object', '-1' );
						
						$object_type = wps_get_object_type($post_or_order_object->ID);

						if ( wps_get_cot_enabled_order_enabled() ) {
							if ('product' == $object_type ) {
								if ( 'variable' == $prod_type ) {
									$availble_variations = $product->get_children();
									if ( !empty( $availble_variations ) ) {
										foreach ( $availble_variations as $variation_key => $variation_id ) {
											if ( wps_keap_get_meta_data( $variation_id, 'mwb_keap_feed_' . $feed_id . '_association', true ) ) {
												$reference_data[] = wps_keap_get_meta_data( $variation_id, 'mwb_keap_feed_' . $feed_id . '_association', true );
											}
										}
									}
								} else {
									$reference_data = wps_keap_get_meta_data( $post_or_order_object->ID, 'mwb_keap_feed_' . $feed_id . '_association', true );
								}
							} else {
								$order = wc_get_order($post_or_order_object->ID);
								$reference_data = $order->get_meta('mwb_keap_feed_' . $feed_id . '_association');
							}
						} else {
							$reference_data = wps_keap_get_meta_data( $post_or_order_object->ID, 'mwb_keap_feed_' . $feed_id . '_association', true );
						}
						if ( ! empty( $reference_data ) ) {
							if ( is_array( $reference_data ) ) {
								foreach ( $reference_data as $k => $v ) {
									if ( false == $v || empty( $crm_object ) ) { // phpcs:ignore
										return;
									}
									$keap_api = Crm_Integration_Keap_Api::get_instance();
									$app_name = $keap_api->get_app_name();
									if ( 'Products' == $crm_object ) {
										$data_href = 'https://' . $app_name . '/app/product/manageProduct?productId=' . $v;
									}
									if ( 'Sales_Orders' == $crm_object ) {
										$data_href = 'https://' . $app_name . '/Job/manageJob.jsp?view=edit&ID=' . $v;
									}
									if ( 'Contacts' == $crm_object ) {
										$data_href = 'https://' . $app_name . '/Contact/manageContact.jsp?view=edit&ID=' . $v;
									}
									$reference_id = $v;
									$item_id      = $post_or_order_object->ID;
									$feed_list[]  = compact( 'feed_title', 'reference_id', 'data_href' );
								}
							} else {
								if ( false == $reference_data || empty( $crm_object ) ) { // phpcs:ignore
									return;
								}
								$keap_api = Crm_Integration_Keap_Api::get_instance();
								$app_name = $keap_api->get_app_name();
								if ( 'Products' == $crm_object ) {
									$data_href = 'https://' . $app_name . '/app/product/manageProduct?productId=' . $reference_data;
								}
								if ( 'Sales_Orders' == $crm_object ) {
									$data_href = 'https://' . $app_name . '/Job/manageJob.jsp?view=edit&ID=' . $reference_data;
								}
								if ( 'Contacts' == $crm_object ) {
									$data_href = 'https://' . $app_name . '/Contact/manageContact.jsp?view=edit&ID=' . $reference_data;
								}
								$reference_id = $reference_data;
								$item_id      = $post_or_order_object->ID;
								$feed_list[]  = compact( 'feed_title', 'reference_id', 'data_href' );
							}
						}
					}
				}
			} else {
				$object_type = wps_get_object_type($post_or_order_object->get_id());
	
				if ( count( $feeds ) ) {
					foreach ( $feeds as $feed_id => $feed_title ) {
						$crm_object = $this->get_feed_data( $feed_id, 'crm_object', '-1' );
						$object_type = wps_get_object_type($post_or_order_object->get_id());
							
						if ( wps_get_cot_enabled_order_enabled() ) {
							if ('product' == $object_type ) {
								$reference_data = wps_keap_get_meta_data( $post_or_order_object->get_id(), 'mwb_keap_feed_' . $feed_id . '_association', true );
							} else {
								$order = wc_get_order($post_or_order_object->get_id());
								$reference_data = $order->get_meta('mwb_keap_feed_' . $feed_id . '_association');
							}
						} else {
							$reference_data = wps_keap_get_meta_data( $post_or_order_object->get_id(), 'mwb_keap_feed_' . $feed_id . '_association', true );
						}

						if ( ! empty( $reference_data ) ) {
							if ( is_array( $reference_data ) ) {
								foreach ( $reference_data as $k => $v ) {
									if ( false == $v || empty( $crm_object ) ) { // phpcs:ignore
										return;
									}
									$keap_api = Crm_Integration_Keap_Api::get_instance();
									$app_name = $keap_api->get_app_name();
									if ( 'Products' == $crm_object ) {
										$data_href = 'https://' . $app_name . '/app/product/manageProduct?productId=' . $v;
									}
									if ( 'Sales_Orders' == $crm_object ) {
										$data_href = 'https://' . $app_name . '/Job/manageJob.jsp?view=edit&ID=' . $v;
									}
									if ( 'Contacts' == $crm_object ) {
										$data_href = 'https://' . $app_name . '/Contact/manageContact.jsp?view=edit&ID=' . $v;
									}
									$reference_id = $v;
									$item_id      = $post_or_order_object->get_id();
									$feed_list[]  = compact( 'feed_title', 'reference_id', 'data_href' );
									$reference_id = $v;
									$item_id      = $post_or_order_object->get_id();
									$feed_list[]  = compact( 'feed_title', 'reference_id', 'data_href' );
								}
							} else {
								if ( false == $reference_data || empty( $crm_object ) ) { // phpcs:ignore
									return;
								}
								$keap_api = Crm_Integration_Keap_Api::get_instance();
								$app_name = $keap_api->get_app_name();
								if ( 'Products' == $crm_object ) {
									$data_href = 'https://' . $app_name . '/app/product/manageProduct?productId=' . $reference_data;
								}
								if ( 'Sales_Orders' == $crm_object ) {
									$data_href = 'https://' . $app_name . '/Job/manageJob.jsp?view=edit&ID=' . $reference_data;
								}
								if ( 'Contacts' == $crm_object ) {
									$data_href = 'https://' . $app_name . '/Contact/manageContact.jsp?view=edit&ID=' . $reference_data;
								}
								$reference_id = $reference_data;
								$item_id      = $post_or_order_object->get_id();
								$feed_list[]  = compact( 'feed_title', 'reference_id', 'data_href' );
							}
						}
						
					}
				}
			}
	
		} else {
			if ( isset( $post_or_order_object->post_type ) ) {
				$item_type     = ( 'product' === $post_or_order_object->post_type ) ? 'Product id' : 'Order id';
			} else {
				$item_type     = 'Order id';
			}
			$feed_list     = array();
			$feeds         = $this->get_available_feeds_for_mapping();
			$variation_ids = array();
			$object_type = wps_get_object_type($post_or_order_object->ID);
		
			if ( count( $feeds ) ) {
				foreach ( $feeds as $feed_id => $feed_title ) {
					$crm_object = $this->get_feed_data( $feed_id, 'crm_object', '-1' );
					
					$object_type = wps_get_object_type($post_or_order_object->ID);
					
					$connection_type = get_option( 'wps-keap-connection-type', 'sandbox' );
					if ( 'sandbox' === $connection_type ) {
						$qb_base_url = 'https://app.sandbox.qbo.intuit.com/app/';
					} else {
						$qb_base_url = 'https://app.qbo.intuit.com/app/';
					}

					if ( wps_get_cot_enabled_order_enabled() ) {
						if ('product' == $object_type ) {
							$reference_data = wps_keap_get_meta_data( $post_or_order_object->ID, 'mwb_keap_feed_' . $feed_id . '_association', true );
						} else {
							$order = wc_get_order($post_or_order_object->ID);
							$reference_data = $order->get_meta('mwb_keap_feed_' . $feed_id . '_association');
						}
					} else {
						$reference_data = wps_keap_get_meta_data( $post_or_order_object->ID, 'mwb_keap_feed_' . $feed_id . '_association', true );
					}
					if ( ! empty( $reference_data ) ) {
						if ( is_array( $reference_data ) ) {
							foreach ( $reference_data as $k => $v ) {
								if ( false == $v || empty( $crm_object ) ) { // phpcs:ignore
									return;
								}
								$keap_api = Crm_Integration_Keap_Api::get_instance();
								$app_name = $keap_api->get_app_name();
								if ( 'Products' == $crm_object ) {
									$data_href = 'https://' . $app_name . '/app/product/manageProduct?productId=' . $v;
								}
								if ( 'Sales_Orders' == $crm_object ) {
									$data_href = 'https://' . $app_name . '/Job/manageJob.jsp?view=edit&ID=' . $v;
								}
								if ( 'Contacts' == $crm_object ) {
									$data_href = 'https://' . $app_name . '/Contact/manageContact.jsp?view=edit&ID=' . $v;
								}
								$reference_id = $v;
								$item_id      = $post_or_order_object->ID;
								$feed_list[]  = compact( 'feed_title', 'reference_id', 'data_href' );
								$reference_id = $v;
								$item_id      = $post_or_order_object->ID;
								$feed_list[]  = compact( 'feed_title', 'reference_id', 'data_href' );
							}
						} else {
							if ( false == $reference_data || empty( $crm_object ) ) { // phpcs:ignore
								return;
							}
							$keap_api = Crm_Integration_Keap_Api::get_instance();
							$app_name = $keap_api->get_app_name();
							if ( 'Products' == $crm_object ) {
								$data_href = 'https://' . $app_name . '/app/product/manageProduct?productId=' . $reference_data;
							}
							if ( 'Sales_Orders' == $crm_object ) {
								$data_href = 'https://' . $app_name . '/Job/manageJob.jsp?view=edit&ID=' . $reference_data;
							}
							if ( 'Contacts' == $crm_object ) {
								$data_href = 'https://' . $app_name . '/Contact/manageContact.jsp?view=edit&ID=' . $reference_data;
							}
							$reference_id = $reference_data;
							$item_id      = $post_or_order_object->ID;
							$feed_list[]  = compact( 'feed_title', 'reference_id', 'data_href' );
						}
					}
				}
			}
		}
		$this->render_meta_box_data( 'feed-list-meta-box', compact( 'feed_list' ) );
	}

	/**
	 * [crm_feed_meta_box_data description].
	 */
	public function crm_feed_meta_box_data() {
		global $post;
		$param = array();
		$module = '';
		$crm_api_module = Crm_Integration_Keap_Api::get_instance();
		$order_statuses = $this->get_woo_order_statuses();
		$params['objects'] = Crm_Integration_For_Keap_Admin::get_available_crm_objects();
		$params['selected_object'] = $this->get_feed_data( $post->ID, 'crm_object', '-1' );
		$params['mapping_data'] = $this->get_feed_data( $post->ID, 'mapping_data', array() );
		$params['status_mapping'] = $this->get_feed_data( $post->ID, 'status_mapping', array() );
		$params['add_line_item'] = $this->get_feed_data( $post->ID, 'add_line_item', 'no' );
		$params['woo_statuses'] = $order_statuses;
		$params['primary_field'] = $this->get_feed_data( $post->ID, 'primary_field', '' );
		$params['feed_event_options'] = $this->get_feed_event_options( $order_statuses );
		$params['feed_event'] = $this->get_feed_data( $post->ID, 'feed_event', '' );
		$params['lead_source_options'] = $this->get_lead_source_options();
		$params['lead_source'] = $this->get_feed_data( $post->ID, 'lead_source', '' );
		$params['crm_fields'] = $crm_api_module->get_module_fields( $params['selected_object'] );
		$params['condition']      = $this->get_feed_data( $post->ID, 'condition_filters', '' );
	
		if ( '-1' == $module ) {
			$this->render_meta_box_data( 'select-object', $params );
		} else {
			$this->render_meta_box_data( 'select-object', $params );
			$this->render_meta_box_data( 'select-fields', $params );
			$this->render_meta_box_data( 'add-new-field', $params );
			if ( 'Contacts' == $params['selected_object'] ) {
				$this->render_meta_box_data( 'lead-source', $params );
			}
			$this->render_meta_box_data( 'order-status-mapping', $params );
			$this->render_meta_box_data( 'product-details', $params );
			$this->render_meta_box_data( 'primary-field', $params );
			$this->render_meta_box_data( 'select-event', $params );
			$this->render_meta_box_data( 'opt-in-condition', $params );
			$this->render_meta_box_data( 'nonce-field', $params );
		}
	}

	/**
	 * [render_meta_box_data description]
	 *
	 * @param string $meta_box Metabox.
	 * @param string $params params.
	 */
	private function render_meta_box_data( $meta_box, $params ) {

		if ( '' == $meta_box ) {
			return;
		}
		$file_path = 'woo-crm-fw/templates/meta-boxes/' . $meta_box . '.php';

		Crm_Integration_For_Keap_Admin::load_template( $file_path, $params, CRM_INTEGRATION_KEAP_PATH );
	}

	/**
	 * Save meta box data for feed custom post type
	 *
	 * @param  int $post_id Id of the cpt.
	 * @return [type]          [description]
	 */
	public function save_metabox_data( $post_id ) {
		
		if ( ! isset( $_POST['_wpnonce'] ) ) {
			return;
		}

		if ( ! isset( $_POST['meta_box_nonce'] ) ) {
			return;
		}

		if ( ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['meta_box_nonce'] ) ), 'meta_box_nonce' ) ) {
			return;
		}

		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			;
			return;
		}

		if ( ! current_user_can( 'edit_post', $post_id ) ) {
			return;
		}
		
		if ( isset( $_POST['post_type'] ) && 'mwb_keap_feed' === $_POST['post_type'] ) {
			
			$crm_object = isset( $_POST['crm_object'] ) ? sanitize_text_field( wp_unslash( $_POST['crm_object'] ) ) : array();
			$crm_field_arr = isset( $_POST['crm_field'] ) ? map_deep( wp_unslash( $_POST['crm_field'] ), 'sanitize_text_field' ) : array();
			$field_type_arr = isset( $_POST['field_type'] ) ? map_deep( wp_unslash( $_POST['field_type'] ), 'sanitize_text_field' ) : array();
			$field_value_arr    = isset( $_POST['field_value'] ) ? map_deep( wp_unslash( $_POST['field_value'] ), 'sanitize_text_field' ) : array();
			$custom_value_arr   = isset( $_POST['custom_value'] ) ? map_deep( wp_unslash( $_POST['custom_value'] ), 'sanitize_text_field' ) : array();
			$custom_field_arr   = isset( $_POST['custom_field'] ) ? map_deep( wp_unslash( $_POST['custom_field'] ), 'sanitize_text_field' ) : array();
			$woo_status         = isset( $_POST['woo_status'] ) ? map_deep( wp_unslash( $_POST['woo_status'] ), 'sanitize_text_field' ) : array();
			$crm_picklist_value = isset( $_POST['crm_picklist_value'] ) ? map_deep( wp_unslash( $_POST['crm_picklist_value'] ), 'sanitize_text_field' ) : array();
			$use_status_mapping = isset( $_POST['use_status_mapping'] ) ? map_deep( wp_unslash( $_POST['use_status_mapping'] ), 'sanitize_text_field' ) : array();
			$add_line_item = isset( $_POST['add_line_item'] ) ? sanitize_text_field( wp_unslash( $_POST['add_line_item'] ) ) : 'no';
			$primary_field = isset( $_POST['primary_field'] ) ? sanitize_text_field( wp_unslash( $_POST['primary_field'] ) ) : '';
			$feed_event = isset( $_POST['feed_event'] ) ? sanitize_text_field( wp_unslash( $_POST['feed_event'] ) ) : '';
			$lead_source = isset( $_POST['lead_source'] ) ? sanitize_text_field( wp_unslash( $_POST['lead_source'] ) ) : '';
			$condition        = isset( $_POST['condition'] ) ? map_deep( wp_unslash( $_POST['condition'] ), 'sanitize_text_field' ) : array();
			$mapping_data = array();
			foreach ( $crm_field_arr as $key => $field ) {
				$field_key = $this->sanitize_input( $field );
				$mapping_data[ $field_key ] = array(
					'field_type' => $this->sanitize_input( $field_type_arr[ $key ] ),
					'field_value' => $this->sanitize_input( $field_value_arr[ $key ] ),
					'custom_value' => $this->sanitize_input( $custom_value_arr[ $key ] ),
					'custom_field' => $this->sanitize_input( $custom_field_arr[ $key ] ),
					'use_status_mapping' => isset( $use_status_mapping[ $field_key ] ) ? 'yes' : 'no',
				);
			}
			$status_mapping = array();
			if ( count( $woo_status ) == count( $crm_picklist_value ) ) {
				foreach ( $woo_status as $key => $value ) {
					$status_mapping[ $this->sanitize_input( $value ) ] =
					$this->sanitize_input( $crm_picklist_value[ $key ] );
				}
			}
			update_post_meta( $post_id, 'crm_object', $crm_object );
			update_post_meta( $post_id, 'mapping_data', $mapping_data );
			update_post_meta( $post_id, 'status_mapping', $status_mapping );
			update_post_meta( $post_id, 'add_line_item', $add_line_item );
			update_post_meta( $post_id, 'primary_field', $primary_field );
			update_post_meta( $post_id, 'feed_event', $feed_event );
			update_post_meta( $post_id, 'lead_source', $lead_source );
			update_post_meta( $post_id, 'condition_filters', $condition );
		}
	}

	/**
	 * Sanitize input
	 *
	 * @param  [type] $input [description].
	 * @return [type]        [description].
	 */
	public function sanitize_input( $input ) {
		return sanitize_text_field( wp_unslash( $input ) );
	}

	/**
	 * [get_feed_selected_object description].
	 *
	 * @param  [type] $post_id [description].
	 * @return [type]          [description].
	 */
	public function get_feed_selected_object( $post_id ) {
		$selected_object = get_post_meta( $post_id, 'crm_object', true );
		$selected_object = ! empty( $selected_object ) ? $selected_object : '-1';
		return $selected_object;
	}

	/**
	 * [get_feed_mapping_data description].
	 *
	 * @param  [type] $post_id [description].
	 * @return [type]          [description].
	 */
	public function get_feed_mapping_data( $post_id ) {
		$mapping_data = get_post_meta( $post_id, 'mapping_data', true );
		$mapping_data = ! empty( $mapping_data ) ? $mapping_data : array();
		return $mapping_data;
	}

	/**
	 * [get_woo_order_statuses description]
	 *
	 * @return [type] [description]
	 */
	public function get_woo_order_statuses() {
		$order_statuses = wc_get_order_statuses();
	   /**
		* Woo order statuses filter hook.
		*
		* @since    1.0.0
		*/
		return apply_filters( 'mwb_woo_crm_order_statuses', $order_statuses );
	}

	/**
	 * [get_feed_mapping_data description].
	 *
	 * @param  string $post_id [description].
	 * @param  string $key [description].
	 * @param  string $default [description].
	 * @return [type]          [description].
	 */
	public function get_feed_data( $post_id, $key, $default ) {
		
		$feed_data = get_post_meta( $post_id, $key, true );
		$feed_data = ! empty( $feed_data ) ? $feed_data : $default;

		return $feed_data;
	}

	/**
	 * [get_feed_event_options description].
	 *
	 * @param  array $order_statuses [description].
	 * @return [type]                 [description].
	 */
	public function get_feed_event_options( $order_statuses = array() ) {

		if ( empty( $order_statuses ) ) {
			$order_statuses = $this->get_woo_order_statuses();
		}

		$options = array();
		$options['new-order'] = __( 'New order is created', 'integration-with-keap' );
		foreach ( $order_statuses as $key => $value ) {
			$options[ $key ] = sprintf(
				/* translators: 1: Order Status.*/
				__( 'Order Status Change to %s', 'integration-with-keap' ),
				$value );
		}
		$options['status_change'] = __( 'Order Status Change', 'integration-with-keap' );
		$options['product_update_create'] = __( 'Product Updated/Created', 'integration-with-keap' );
		$options['user_update_create'] = __( 'WP User Updated/Created', 'integration-with-keap' );
		$options['send_manually'] = __( 'Send Manually', 'integration-with-keap' );
		return $options;
	}

	/**
	 * [get_lead_source_options description].
	 *
	 * @param  array $order_statuses [description].
	 * @return [type]                 [description].
	 */
	public function get_lead_source_options() {

		$options['-1'] = __( '--Select Lead Source--', 'integration-with-keap' );
		$options['6'] = __( 'Advertisement', 'integration-with-keap' );
		$options['9'] = __( 'Direct Mail', 'integration-with-keap' );
		$options['11'] = __( 'Online - Organic Search Engine', 'integration-with-keap' );
		$options['12'] = __( 'Online - Pay Per Click', 'integration-with-keap' );
		$options['15'] = __( 'Keap App Name', 'integration-with-keap' );
		$options['7'] = __( 'Referral - From Affiliate/Partner', 'integration-with-keap' );
		$options['8'] = __( 'Referral - From Customer', 'integration-with-keap' );
		$options['13'] = __( 'Trade Show', 'integration-with-keap' );
		$options['10'] = __( 'Yellow Pages', 'integration-with-keap' );
		return $options;
	}

	/**
	 * [may_be_create_default_feeds description].
	 *
	 * @return [type] [description].
	 */
	public function may_be_create_default_feeds() {

		if ( ! post_type_exists( 'mwb_keap_feed' ) ) {
			return;
		}

		if ( get_option( 'mwb_woo_keap_default_feeds_created', false ) ) {
			return;
		}

		foreach ( $this->get_default_feeds() as $key => $feed ) {

			$args = array(
				'post_type'   => 'mwb_keap_feed',
				'post_status' => 'publish',
				'post_title'  => $feed['title'],
				'meta_input'  => $this->get_feed_meta_data( $feed['crm_object'] ),
			);

			$feed_id = wp_insert_post( $args );

			if ( ! is_wp_error( $feed_id ) ) {
				update_option( 'mwb_woo_keap_default_' . $feed['crm_object'] . '_feed_id', $feed_id );
			}
		}

		update_option( 'mwb_woo_keap_default_feeds_created', true );
	}

	/**
	 * [get_default_feeds description].
	 *
	 * @return [type] [description].
	 */
	public function get_default_feeds() {

		$default_feeds = array(

			array(
				'type'       => 'product',
				'crm_object' => 'Products',
				'title'      => __( 'Default Products Feed', 'integration-with-keap' ),
			),

			array(
				'type'       => 'contact',
				'crm_object' => 'Contacts',
				'title'      => __( 'Default Contacts Feed', 'integration-with-keap' ),
			),
			array(
				'type'       => 'order',
				'crm_object' => 'Sales_Orders',
				'title'      => __( 'Default Sales Order Feed', 'integration-with-keap' ),
			),

		);

	   /**
		* Plugin default feeds filter hook.
		*
		* @since    1.0.0
		*/
		return apply_filters( 'mwb_woo_keap_default_feeds', $default_feeds );
	}

	/**
	 * [get_feed_meta_data description].
	 *
	 * @param string $feed_object feed_object.
	 * @return [type] [description].
	 */
	public function get_feed_meta_data( $feed_object ) {

		$meta_input = array(
			'crm_object'     => $feed_object,
			'mapping_data'   => self::get_default_mapping_data( $feed_object ),
			'status_mapping' => self::get_default_status_mapping( $feed_object ),
			'add_line_item'  => self::get_default_add_line_item( $feed_object ),
			'feed_event'     => self::get_default_event( $feed_object ),
			'primary_field'  => self::get_default_primary_field( $feed_object ),
			'default_feed'   => true,
		);

		return $meta_input;
	}

	/**
	 * [get_default_add_line_item description].
	 *
	 * @param  string $module [description].
	 * @return [type]         [description].
	 */
	public static function get_default_add_line_item( $module ) {

		if ( in_array( $module, array( 'Sales_Orders' ) ) ) {
			return 'yes';
		}
		return 'no';
	}

	/**
	 * [get_default_status_mapping description].
	 *
	 * @param  string $module [description].
	 * @return [type]         [description].
	 */
	public static function get_default_status_mapping( $module ) {

		$status_mapping = array();
		$order_statuses = wc_get_order_statuses();
		if ( 'Sales_Orders' === $module ) {
			foreach ( $order_statuses as $key => $value ) {
				switch ( $key ) {
					case 'wc-pending':
						$status_mapping[ $key ] = 'Created';
						break;
					case 'wc-processing':
						$status_mapping[ $key ] = 'Approved';
						break;
					case 'wc-on-hold':
						$status_mapping[ $key ] = 'Created';
						break;
					case 'wc-completed':
						$status_mapping[ $key ] = 'Delivered';
						break;
					case 'wc-cancelled':
						$status_mapping[ $key ] = 'Cancelled';
						break;
					case 'wc-refunded':
						$status_mapping[ $key ] = 'Cancelled';
						break;
					case 'wc-failed':
						$status_mapping[ $key ] = 'Cancelled';
						break;
					default:
						$status_mapping[ $key ] = 'Created';
						break;
				}
			}
		}

		return $status_mapping;
	}


	/**
	 * Get default mapping and data
	 *
	 * @param  string $module [description].
	 * @return [type]         [description].
	 */
	public static function get_default_mapping_data( $module ) {

		$contact_feed_id = get_option( 'mwb_woo_keap_default_Contacts_feed_id', '' );

		$contact_feed    = ! empty( $contact_feed_id ) ? 'feeds_' . $contact_feed_id : '';

		$deal_feed_id = get_option( 'mwb_woo_keap_default_Deals_feed_id', '' );
		$deal_feed    = ! empty( $deal_feed_id ) ? 'feeds_' . $deal_feed_id : '';

		$mapping_data['Products'] = array(

			'product_name' => array(
				'field_type' => 'standard_field',
				'field_value' => 'product_product_name',
			),

			'product_price' => array(
				'field_type' => 'standard_field',
				'field_value' => 'product__regular_price',
			),

			'sku' => array(
				'field_type' => 'standard_field',
				'field_value' => 'product__sku',
			),

			'product_short_desc' => array(
				'field_type' => 'standard_field',
				'field_value' => 'product_product_short_description',
			),
			'product_desc' => array(
				'field_type' => 'standard_field',
				'field_value' => 'product_product_description',
			),

		);

		$mapping_data['Contacts'] = array(
			'given_name' => array(
				'field_type' => 'standard_field',
				'field_value' => 'shop_order__billing_first_name',
			),
			'family_name' => array(
				'field_type' => 'standard_field',
				'field_value' => 'shop_order__billing_last_name',
			),
			'email' => array(
				'field_type' => 'standard_field',
				'field_value' => 'shop_order__billing_email',
			),
			'number' => array(
				'field_type' => 'standard_field',
				'field_value' => 'shop_order__billing_phone',
			),
			'line1' => array(
				'field_type' => 'custom_value',
				'custom_value' => '{shop_order__billing_address_1} ',
			),
			'line2' => array(
				'field_type' => 'custom_value',
				'custom_value' => '{shop_order__billing_address_2} ',
			),
			'locality' => array(
				'field_type' => 'standard_field',
				'field_value' => 'shop_order__billing_city',
			),
			'region' => array(
				'field_type' => 'standard_field',
				'field_value' => 'shop_order__billing_state',
			),

			'country_code' => array(
				'field_type' => 'standard_field',
				'field_value' => 'shop_order__billing_country',
			),
			'zip_code' => array(
				'field_type' => 'standard_field',
				'field_value' => 'shop_order__billing_postcode',
			),
			'postal_code' => array(
				'field_type' => 'standard_field',
				'field_value' => 'shop_order__billing_postcode',
			),
		);

		$mapping_data['Sales_Orders'] = array(

			'order_title' => array(
				'field_type' => 'custom_value',
				'custom_value' => 'woo-order-{shop_order_order_id}',
			),
			'status' => array(
				'field_type' => 'standard_field',
				'field_value' => 'Created',
				'use_status_mapping' => 'yes',
			),
			'email' => array(
				'field_type' => 'standard_field',
				'field_value' => 'shop_order__billing_email',
			),
			'first_name' => array(
				'field_type' => 'standard_field',
				'field_value' => 'shop_order__billing_first_name',
			),
			'last_name' => array(
				'field_type' => 'standard_field',
				'field_value' => 'shop_order__billing_last_name',
			),

			'phone' => array(
				'field_type' => 'standard_field',
				'field_value' => 'shop_order__billing_phone',
			),
			'line1' => array(
				'field_type' => 'custom_value',
				'custom_value' => '{shop_order__billing_address_1} ',
			),
			'line2' => array(
				'field_type' => 'custom_value',
				'custom_value' => '{shop_order__billing_address_2} ',
			),
			'locality' => array(
				'field_type' => 'standard_field',
				'field_value' => 'shop_order__billing_city',
			),
			'region' => array(
				'field_type' => 'standard_field',
				'field_value' => 'shop_order__billing_state',
			),
			'zip_code' => array(
				'field_type' => 'standard_field',
				'field_value' => 'shop_order__billing_postcode',
			),
			'country_code' => array(
				'field_type' => 'standard_field',
				'field_value' => 'shop_order__billing_country',
			),

			'total' => array(
				'field_type' => 'standard_field',
				'field_value' => 'shop_order__order_total',
			),

		);

		return isset( $mapping_data[ $module ] ) ? $mapping_data[ $module ] : array();
	}

	/**
	 * [get_default_event description].
	 *
	 * @param  [type] $module [description].
	 * @return [type]         [description].
	 */
	public static function get_default_event( $module ) {
		$event = '';

		switch ( $module ) {

			case 'Sales_Orders':
				$event = 'status_change';
				break;
			case 'Products':
				$event = 'product_update_create';
				break;
			case 'Contacts':
				$event = 'new-order';
				break;
			default:
				$event = 'send_manually';
				break;
		}

		return $event;
	}

	/**
	 * [get_default_primary_field description].
	 *
	 * @param  [type] $module [description].
	 * @return [type]         [description].
	 */
	public static function get_default_primary_field( $module ) {

		$default_primary = '';
		switch ( $module ) {

			case 'Sales_Orders':
				$default_primary = 'Email';
				break;
			case 'Products':
				$default_primary = 'Product_Name';
				break;
			case 'Contacts':
				$default_primary = 'Email';
				break;

		}

		return $default_primary;
	}

	/**
	 * Create feed post.
	 *
	 * @param  text $title  Feed title.
	 * @param  text $object Feed object.
	 * @return int          Feed id.
	 */
	public function create_feed_post( $title, $object ) {

		$args = array(

			'post_type'   => 'mwb_keap_feed',
			'post_status' => 'publish',
			'post_title'  => $title,
			'meta_input'  => $this->get_feed_meta_data( $object ),
		);

		$feed_id = wp_insert_post( $args );
		return $feed_id;
	}

	/**
	 * Check is feed post exists.
	 *
	 * @param  int $feed_id Feed id.
	 * @return mix
	 */
	public function is_valid_feed_post( $feed_id ) {

		$post   = get_post( $feed_id );

		$return = false;

		if ( ! empty( $post ) && 'publish' == $post->post_status ) {
			$return = $feed_id;
		}

		return $return;
	}

		/**
		 * [get_available_feeds_for_mapping description].
		 *
		 * @return [type] [description].
		 */
	public function get_available_feeds_for_mapping() {
		$all_feeds = $this->get_available_feeds();
		if ( ! $all_feeds ) {
			return array();
		}
		$feed_list = array();
		foreach ( $all_feeds as $key => $feed ) {
			$feed_list[ $feed->ID ] = $feed->post_title;
		}
		return $feed_list;
	}

	/**
	 * Get available feeds.
	 *
	 * @param array $status Array of status.
	 */
	public function get_available_feeds( $status = array() ) {

		$status = empty( $status ) ? 'publish' : $status;
		$args   = array(
			'post_type'   => 'mwb_keap_feed',
			'post_status' => $status,
			'numberposts' => -1,
		);
		$feeds  = get_posts( $args );
		return $feeds;
	}

	/**
	 * Add shop order meta box.
	 */
	public function shop_order_meta_box_data( $post_or_order_object ) {

		if ( isset( $post_or_order_object->post_type ) && 'product' == $post_or_order_object->post_type ) {
			$post_order_id  = $post_or_order_object->ID;
		} elseif ( OrderUtil::custom_orders_table_usage_is_enabled() ) {
			if ( isset( $_GET['_wpnonce'] ) && wp_verify_nonce( sanitize_text_field( wp_unslash( $_GET['_wpnonce'] ) ) ) ) {
				$o_id = !empty( $_GET['id'] ) ? sanitize_text_field( wp_unslash( $_GET['id'] ) ) : '';
				$p_id = !empty( $_GET['post'] ) ? sanitize_text_field( wp_unslash( $_GET['post'] ) ) : '';
			}
			if ( empty( $o_id ) && !empty( $p_id ) ) {
				$post_order_id  = $post_or_order_object->ID;
			} else {
				$post_order_id  = $post_or_order_object->get_id();
			}
		} else {
			$post_order_id  = $post_or_order_object->ID;
		}
		$params = array();
		$feeds  = $this->get_available_feeds_for_mapping();
		array_pop( $feeds );
		$this->render_meta_box_data( 'order-meta-box', compact( 'feeds', 'post_order_id' ) );
	}

	/**
	 * Check for default feed post.
	 *
	 * @param  string $crm_object   CRM Object.
	 * @return int/bool             Feed id or False.
	 */
	public function check_for_feed_post( $crm_object ) {

		$query_args = array(
			array(
				'key'     => 'crm_object',
				'value'   => $crm_object,
				'compare' => '=',
			),
			array(
				'key'     => 'default_feed',
				'value'   => true,
				'compare' => '=',
			),
		);
		$args   = array(
			'post_type'   => 'mwb_keap_feed',
			'post_status' => 'publish',
			'meta_query'  => $query_args,
		);
		$feeds  = get_posts( $args );

		$feed_id = ! empty( $feeds ) ? $feeds[0]->ID : false;

		return $feed_id;
	}

	/** 
	* Get All Products data for tag.    
	*   
	* @return int/bool             Feed id or False.    
	*/  
	public function get_all_produucts_for_tag() {   
		$object_type = array( 'product', 'product_variation' );    
		$tags = array();    
		$args = array(  
		'post_type'  => $object_type,
		'post_status' => 'publish', 
		);  
		try {   
			$products_query = new WP_Query( $args );    
			$bulk_request = array();    
			$bulk_ids = array();    
			$total = $products_query->found_posts;  
			while ( $products_query->have_posts() ) :   
			$products_query->the_post();    
			// Get product. 
			$product = wc_get_product( get_the_ID() );  
				if ($product) { 
					if ( ! empty($product->get_sku() ) ) {  
					$tags[] = $product->get_sku();  
					}   
					if ( ! empty($product->get_type() ) ) { 
					$tags[] = $product->get_type(); 
					}   
					if ( ! empty($product->get_name() ) ) { 
					$tags[] = $product->get_name(); 
					}   
				}   
			endwhile;   
		} catch ( \Throwable $th ) {    
			$msg = $th->getMessage();   
			if ( defined( 'WP_DEBUG' ) && WP_DEBUG && current_user_can( 'manage_woocommerce' ) ) {  
				echo esc_html( $msg );  
			}   
		}   
		$all_tags = array_unique($tags);    
		return $all_tags;   
	}   
	//END
}
