<?php
/**
 * Fired during plugin activation
 *
 * @link       https://wpswings.com/
 * @since      1.0.0
 *
 * @package    Integration_With_keap
 * @subpackage Integration_With_keap/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Integration_With_keap
 * @subpackage Integration_With_keap/includes
 */
class Crm_Integration_For_Keap_Activator {

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.0.0
	 */
	public static function activate() {

		// Create log table in database.
		self::may_be_create_log_table();

		// Schedule clear log event.
		self::add_scheduled_event();

		update_option( 'mwb_woo_keap_log_last_delete', time() );
	}


	/**
	 * Schedule clear log event.
	 */
	public static function add_scheduled_event() {
		if ( ! wp_next_scheduled( 'mwb_woo_keap_clear_log' ) ) {
			wp_schedule_event( time(), 'daily', 'mwb_woo_keap_clear_log' );
		}
	}

	/**
	 * Create log table in database.
	 */
	public static function may_be_create_log_table() {

		if ( get_option( 'mwb_woo_keap_log_table', false ) ) {
			return;
		}
		require_once plugin_dir_path( __DIR__ ) . 'woo-includes/woo-functions.php';
		global $wpdb;
		$table = $wpdb->prefix . 'mwb_woo_keap_log';
		$query = "CREATE TABLE IF NOT EXISTS $table (
            `id` int(11) NOT NULL AUTO_INCREMENT,
            `woo_object` varchar(255) NOT NULL,
            `woo_id` int(11) NOT NULL,
            `keap_object` varchar(255) NOT NULL,
            `keap_id` varchar(255) ,
            `event` varchar(255) NOT NULL,
            `request` text NOT NULL,
            `response` text ,
            `time` int(11) NOT NULL,
            PRIMARY KEY (`id`)
          ) ENGINE=InnoDB DEFAULT CHARSET=utf8;";

		mwb_woo_keap_execute_db_query( $query );
		update_option( 'mwb_woo_keap_log_table_created', true );
	}
}
