<?php
/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://wpswings.com/
 * @since      1.0.0
 *
 * @package    Integration_With_keap
 * @subpackage Integration_With_keap/admin/partials
 */

?>

<div class="mwb-body-container">
	<?php if ( get_option( 'mwb-woo-keap-authorised', false ) && get_option( 'mwb-woo-keap-onboarding-completed', false ) ) : ?>
		
		<div class="mwb-crm-name">
				<h1 class="mwb-crm-name__title">
					<?php printf( '%s %s', esc_html__( 'Keap', 'integration-with-keap' ), esc_html__( 'Integration for WooCommerce', 'integration-with-keap' ) ); ?>
					  
				</h1>
				<div class="mwb-crm-name__version">
				   <?php printf( 'V %s', esc_html( CRM_INTEGRATION_KEAP_VERSION ) ); ?>
				</div>
			</div>
			<!-- Dashboard Screen. -->
		<?php
	   /**
		* Plugin connect dashboard action hook.
		*
		* @since    1.0.0
		*/
		do_action( 'mwb-woo-connect-dashboard-screen' );
		?>
		
		<?php else : ?>
			<!-- Authorisation Screen. -->
			<?php
		   /**
			* Plugin connect authorisation action hook.
			*
			* @since    1.0.0
			*/
			do_action( 'mwb-woo-connect-authorisation-screen' );
			?>
			<div class="mwb-skype-wrap">
<?php Crm_Integration_For_Keap_Admin::add_skype_connect(); ?>	
</div>
<ul class="mwb-about__list">
	<li class="mwb-about__list-item">	
		<div class="mwb-about__list-item-text">
			<p><?php esc_html_e( 'Need any help ? Check our documentation.', 'integration-with-keap' ); ?></p>
		</div>
		<div class="mwb-about__list-item-btn">
			<a href="https://docs.woocommerce.com/document/integration-with-keap/" target="blank" class="mwb-btn mwb-btn--filled" onclick="">
				<?php esc_html_e( 'Documentation', 'integration-with-keap' ); ?>
			</a>
		</div>
	</li>
	<li class="mwb-about__list-item">
		<div class="mwb-about__list-item-text">
			<p><?php esc_html_e( 'Facing any issue ? Open a support ticket.', 'integration-with-keap' ); ?></p>
		</div>
		<div class="mwb-about__list-item-btn">
			<a href="https://wpswings.com/submit-query/?utm_source=wpswings-keap-woo&utm_medium=woo-backend&utm_campaign=submit-query" target="blank" class="mwb-btn mwb-btn--filled" onclick="">
				<?php esc_html_e( 'Support', 'integration-with-keap' ); ?>
			</a>
		</div>
	</li>
	<li class="mwb-about__list-item">
		<div class="mwb-about__list-item-text">
			<p><?php esc_html_e( 'Need personalized solution, contact us !', 'integration-with-keap' ); ?></p>
		</div>
		<div class="mwb-about__list-item-btn">
			<a href="https://wpswings.com/contact-us/?utm_source=wpswings-keap-woo&utm_medium=woo-backend&utm_campaign=official"  target="blank" class="mwb-btn mwb-btn--filled" onclick="">
				<?php esc_html_e( 'Connect', 'integration-with-keap' ); ?>
			</a>
		</div>
	</li>
</ul>
	<?php endif; ?>
</div>
