<?php

namespace ImageHopper\ImageHopper\ThirdParty\GravityFlow;

/**
 * @package     Image Hopper
 * @copyright   Copyright (c) 2025, Image Hopper
 * @license     https://opensource.org/licenses/gpl-3.0.php GNU Public License
 */

/**
 * @since 2.4.3
 */
class FormConnector {
	public function init() {
		add_filter( 'gravityflowformconnector_new_entry', [ $this, 'map_image_hopper_fields' ], 10, 5 );
		add_filter( 'gravityflowformconnector_update_entry', [ $this, 'map_image_hopper_fields' ], 10, 5 );
		add_filter( 'gravityflowformconnector_update_field_values', [ $this, 'map_image_hopper_fields' ], 10, 5 );
	}

	/**
	 * Update any Image Hopper field mappings
	 *
	 * @param array $new_entry
	 * @param array $entry
	 * @param array $form
	 * @param array $target_form
	 * @param \Gravity_Flow_Step $step
	 *
	 * @return array
	 *
	 * @since 2.4.3
	 */
	public function map_image_hopper_fields( $new_entry, $entry, $form, $target_form, $step ) {
		foreach ( $step->mappings as $mapping ) {
			if ( rgblank( $mapping['key'] ) ) {
				continue;
			}

			$target_field_id = (string) trim( $mapping['key'] );
			$source_field_id = (string) $mapping['value'];
			$source_field    = \GFFormsModel::get_field( $form, $source_field_id );

			if ( ! is_object( $source_field ) || $source_field->type !== 'image_hopper' ) {
				continue;
			}

			$new_entry[ $target_field_id ] = $entry[ $source_field_id ];
		}

		return $new_entry;
	}
}
