import { setUploadedFiles } from './setUploadedFiles'
import { removeCacheBustingFromUrl } from './cacheBusting'

/**
 * @package     Image Hopper
 * @copyright   Copyright (c) 2025, Image Hopper
 * @license     https://opensource.org/licenses/gpl-3.0.php GNU Public License
 */

export function reorderFiles (files, fieldId, formId) {
  const reorderedFiles = []

  files.forEach((file) => {
    const fileId = file.serverId || ''
    if (fileId.startsWith('http://') || fileId.startsWith('https://')) {
      reorderedFiles.push({
        temp_filename: '',
        uploaded_filename: removeCacheBustingFromUrl(fileId)
      })
    } else {
      reorderedFiles.push({
        temp_filename: fileId,
        uploaded_filename: file.filename
      })
    }
  })

  setUploadedFiles(fieldId, reorderedFiles, formId)
}
