import $ from 'jquery'

/**
 * @package     Image Hopper
 * @copyright   Copyright (c) 2025, Image Hopper
 * @license     https://opensource.org/licenses/gpl-3.0.php GNU Public License
 */

const l10n = image_hopper_js_strings.l10n

export function removeMinimumWarningMessage (pond, id) {
  $(pond).parent()
    .find('.minimum_image_size_warning[data-file-id="' + id + '"]')
    .remove()
}

export function maybeAddMinimumWarningMessage (pond, id, filename, width, height, minWidth, minHeight) {
  let message = ''

  if (width < minWidth && height < minHeight) {
    message = l10n.imageValidationMinimumImageSizeWarning
      .replace('%1$s', filename)
      .replace('%2$s', minWidth)
      .replace('%3$s', minHeight)
  }

  if (width < minWidth && height >= minHeight) {
    message = l10n.imageValidationMinimumImageSizeWidthWarning
      .replace('%1$s', filename)
      .replace('%2$s', minWidth)
  }

  if (height < minHeight && width >= minWidth) {
    message = l10n.imageValidationMinimumImageSizeHeightWarning
      .replace('%1$s', filename)
      .replace('%2$s', minHeight)
  }

  if (message.length === 0) {
    return
  }

  const warning = $('<div class="gfield_description validation_message gfield_validation_message validation_message minimum_image_size_warning">')
    .attr('data-file-id', id)
    .html(message)

  $(pond).parent().find('.ih-feedback-messages').append(warning)
}
