<?php

namespace ImageHopper\ImageHopper\ThirdParty\Siteground;

/**
 * @package     Image Hopper
 * @copyright   Copyright (c) 2025, Image Hopper
 * @license     https://opensource.org/licenses/gpl-3.0.php GNU Public License
 */

/**
 * @since 2.13.0
 */
class SpeedOptimizer {

	private static $_instance = null;

	/**
	 * Returns an instance of this class, and stores it in the $_instance property.
	 *
	 * @return self $_instance An instance of this class.
	 *
	 * @since 2.13.0
	 */
	public static function get_instance() {
		if ( self::$_instance === null ) {
			self::$_instance = new self();
		}

		return self::$_instance;
	}

	/**
	 * @since 2.13.0
	 */
	public function init() {
		add_filter( 'sgo_js_minify_exclude', [ $this, 'exclude_js_from_minifier' ] );
	}

	/**
	 * Exclude the Image Hopper JS files from being minified by the Siteground Speed Optimizer.
	 * As the files are already minified, errors are created by this tool.
	 *
	 * @param array $exclude_list
	 *
	 * @return array
	 *
	 * @since 2.13.0
	 */
	public function exclude_js_from_minifier( $exclude_list ) {
		/* handle unexpected type */
		if ( ! is_array( $exclude_list ) ) {
			return $exclude_list;
		}

		$exclude_list[] = 'image_hopper_js';
		$exclude_list[] = 'image_hopper_js_modern';
		$exclude_list[] = 'image_hopper_editor_js';

		return $exclude_list;
	}
}
