import { getFiles } from './getFiles'
import { setUploadedFiles } from './setUploadedFiles'
import { removeExtension } from './removeExtension'

/**
 * @package     Image Hopper
 * @copyright   Copyright (c) 2025, Image Hopper
 * @license     https://opensource.org/licenses/gpl-3.0.php GNU Public License
 */

export function addFile (formId, fieldId, fileInfo, index = -1) {
  const files = getFiles(fieldId, formId)

  if (index === -1) {
    files.push(fileInfo)
  } else {
    files.splice(index, 0, fileInfo)
  }

  setUploadedFiles(fieldId, files, formId)
}

/**
 * When an image is reordered before the upload is complete, it'll be added to our file list already and we should
 * update the object instead of appending to the end
 */
export function addOrUpdateFile (formId, fieldId, originalFile, fileInfo) {
  const files = getFiles(fieldId, formId)

  let found = false
  files.forEach((file, index) => {
    if (removeExtension(originalFile.name) === removeExtension(file.uploaded_filename)) {
      found = true
      files[index] = fileInfo
    }
  })

  if (!found) {
    files.push(fileInfo)
  }

  setUploadedFiles(fieldId, files, formId)
}
