<?php

namespace ImageHopper\ImageHopper\ThirdParty\HideMyWp;

/**
 * @package     Image Hopper
 * @copyright   Copyright (c) 2025, Image Hopper
 * @license     https://opensource.org/licenses/gpl-3.0.php GNU Public License
 */

/**
 * @since 2.5.0
 */
class FilePath {

	private static $_instance = null;

	/**
	 * Returns an instance of this class, and stores it in the $_instance property.
	 *
	 * @return self $_instance An instance of this class.
	 *
	 * @since 2.5
	 */
	public static function get_instance() {
		if ( self::$_instance === null ) {
			self::$_instance = new self();
		}

		return self::$_instance;
	}

	/**
	 * @since 2.5.0
	 */
	public function init() {
		add_filter( 'image_hopper_pre_get_value_save_entry', [ $this, 'fix_path_mask' ], 10, 5 );
	}

	public function fix_path_mask( $value, $form, $input_name, $lead_id, $lead ) {
		global $HideMyWP;

		/* Verify the global variable is the correct class */
		if ( get_class( $HideMyWP ) !== 'HideMyWP' ) {
			return $value;
		}

		/* Get access to the private properties which contain the original and masked strings */
		$class     = new \ReflectionClass( $HideMyWP );
		$property1 = $class->getProperty( 'replace_old' );
		$property1->setAccessible( true );
		$property2 = $class->getProperty( 'replace_new' );
		$property2->setAccessible( true );

		$original_path = $property1->getValue( $HideMyWP );
		$masked_path   = $property2->getValue( $HideMyWP );

		/* Verify both are arrays of equal length */
		if ( ! is_array( $original_path ) || ! is_array( $masked_path ) || count( $original_path ) !== count( $masked_path ) ) {
			return $value;
		}

		if ( isset( \GFFormsModel::$uploaded_files[ $form['id'] ][ $input_name ] ) ) {
			foreach ( \GFFormsModel::$uploaded_files[ $form['id'] ][ $input_name ] as &$file ) {
				$file['uploaded_filename'] = str_ireplace( $masked_path, $original_path, $file['uploaded_filename'] );
			}
		}

		$posted_files = \GFCommon::json_decode( stripslashes( \GFForms::post( 'gform_uploaded_files' ) ) );
		if ( isset( $posted_files[ $input_name ] ) ) {
			foreach ( $posted_files[ $input_name ] as &$file ) {
				$file['uploaded_filename'] = str_ireplace( $masked_path, $original_path, $file['uploaded_filename'] );
			}
		}

		$_POST['gform_uploaded_files'] = wp_json_encode( $posted_files, JSON_UNESCAPED_UNICODE );

		return $value;
	}
}
