<?php

namespace ImageHopper\ImageHopper\ThirdParty\GravityView;

/**
 * @package     Image Hopper
 * @copyright   Copyright (c) 2025, Image Hopper
 * @license     https://opensource.org/licenses/gpl-3.0.php GNU Public License
 */

/**
 * @since 2.16.2
 */
class MergeTags {
	public function init() {
		add_filter(
			'gravityview/merge_tags/modifiers/value',
			function ( $return_value, $raw_value, $value, $merge_tag, $modifier, $field ) {
				return $this->undo_gv_modifier_for_image_hopper( $return_value, $raw_value, $value, $merge_tag, $modifier, $field );
			},
			10,
			6
		);
	}

	/**
	 * GravityView listens for specific merge tag modifiers and overrides the standard formatting of IH tags
	 * This will undo that behaviour for IH fields so users can safely use {IH:2:urlencode} without getting
	 * unexpected results.
	 *
	 * @param $return_value
	 * @param $raw_value
	 * @param $value
	 * @param $merge_tag
	 * @param $modifier
	 * @param $field
	 *
	 * @return mixed
	 *
	 * @since 2.16.2
	 */
	protected function undo_gv_modifier_for_image_hopper( $return_value, $raw_value, $value, $merge_tag, $modifier, $field ) {
		/* Ignore non-IH field */
		if ( $field->type !== 'image_hopper' ) {
			return $return_value;
		}

		/* return original value already processed by IH */

		return $value;
	}
}
