<?php

namespace ImageHopper\ImageHopper\ThirdParty\GravityPerks;

/**
 * @package     Image Hopper
 * @copyright   Copyright (c) 2025, Image Hopper
 * @license     https://opensource.org/licenses/gpl-3.0.php GNU Public License
 */

/**
 * @since 2.16.3
 */
class EntryBlocks {

	private static $_instance = null;

	/**
	 * Returns an instance of this class, and stores it in the $_instance property.
	 *
	 * @return self $_instance An instance of this class.
	 *
	 * @since 2.16.3
	 */
	public static function get_instance() {
		if ( self::$_instance === null ) {
			self::$_instance = new self();
		}

		return self::$_instance;
	}

	/**
	 * @since 2.16.3
	 */
	public function init() {
		add_filter(
			'image_hopper_validation_entry_id',
			function ( $entry_id ) {
				return $this->set_entry_id( $entry_id );
			}
		);
	}

	/**
	 * If editing an entry with the Entry Block perk return the correct ID
	 *
	 * @param int $entry_id
	 *
	 * @return int
	 */
	protected function set_entry_id( $entry_id ) {
		if (
			! empty( rgpost( 'gpeb_block_uuid' ) ) &&
			! empty( rgpost( 'gpeb_entry_id' ) )
		) {
			return (int) rgpost( 'gpeb_entry_id' );
		}

		return $entry_id;
	}
}
