/**
 * @package     Image Hopper
 * @copyright   Copyright (c) 2025, Image Hopper
 * @license     https://opensource.org/licenses/gpl-3.0.php GNU Public License
 */

export function addCacheBustingToUrl (url) {
  try {
    const urlObject = new URL(url)
    urlObject.searchParams.append('t', Date.now().toString())

    return decodeURI(urlObject.toString())
  } catch (e) {
    return url
  }
}

export function removeCacheBustingFromUrl (url) {
  try {
    const urlObject = new URL(url)
    urlObject.searchParams.delete('t')

    return decodeURI(urlObject.toString())
  } catch (e) {
    return url
  }
}
