<?php

namespace ImageHopper\ImageHopper\ThirdParty\Avatars;

/**
 * @package     Image Hopper
 * @copyright   Copyright (c) 2025, Image Hopper
 * @license     https://opensource.org/licenses/gpl-3.0.php GNU Public License
 */

/**
 * @since 2.2
 */
class BasicUserAvatars extends Avatars {

	public function get_user_meta_key() {
		return 'basic_user_avatar';
	}

	public function encode( $value ) {
		return [ 'full' => esc_url_raw( $value ) ];
	}

	public function decode( $value ) {
		return ! empty( $value['full'] ) ? $value['full'] : '';
	}
}
