<?php

namespace ImageHopper\ImageHopper\FirstParty;

/**
 * @package     Image Hopper
 * @copyright   Copyright (c) 2025, Image Hopper
 * @license     https://opensource.org/licenses/gpl-3.0.php GNU Public License
 */

/**
 * @since 2.13.3
 */
class TrackEntryInField {

	/**
	 * @var object $_instance If available, contains an instance of this class.
	 *
	 * @since 2.13.3
	 */
	private static $_instance = null;

	/**
	 * Returns an instance of this class, and stores it in the $_instance property.
	 *
	 * @return self $_instance An instance of this class.
	 *
	 * @since 2.13.3
	 */
	public static function get_instance() {
		if ( self::$_instance === null ) {
			self::$_instance = new self();
		}

		return self::$_instance;
	}

	/**
	 * @since 2.13.3
	 */
	public function init() {
		add_filter( 'gform_get_field_value', [ $this, 'maybe_save_entry_to_field' ], 10, 3 );
	}

	/**
	 * If IH field, store the entry in the field object for later use
	 *
	 * @param mixed     $value
	 * @param array     $lead
	 * @param \GF_Field $field
	 *
	 * @return mixed
	 *
	 * @since 2.13.3
	 */
	public function maybe_save_entry_to_field( $value, $lead, $field ) {
		if (
			! $field instanceof \GF_Field
			|| ! in_array( $field->type, [ 'image_hopper', 'image_hopper_post' ], true )
		) {
			return $value;
		}

		$field->current_entry = $lead;

		return $value;
	}
}
