<?php

namespace ImageHopper\ImageHopper\FirstParty;

/**
 * @package     Image Hopper
 * @copyright   Copyright (c) 2025, Image Hopper
 * @license     https://opensource.org/licenses/gpl-3.0.php GNU Public License
 */

/**
 * @since 2.16
 */
class Capabilities {

	/**
	 * @var object $_instance If available, contains an instance of this class.
	 *
	 * @since 2.16
	 */
	private static $_instance = null;

	/**
	 * Returns an instance of this class, and stores it in the $_instance property.
	 *
	 * @return self $_instance An instance of this class.
	 *
	 * @since 2.16
	 */
	public static function get_instance() {
		if ( self::$_instance === null ) {
			self::$_instance = new self();
		}

		return self::$_instance;
	}

	/**
	 * Add IH capabilities for users
	 *
	 * @return void
	 *
	 * @since 2.16
	 */
	public function add_capabilities_to_users() {
		global $wp_roles;

		if ( class_exists( '\WP_Roles' ) ) {
			if ( ! isset( $wp_roles ) ) {
				$wp_roles = new \WP_Roles(); // phpcs:ignore
			}
		}

		if ( ! is_object( $wp_roles ) ) {
			return;
		}

		/* Add Image Hopper capabilities to the administrator role */
		$wp_roles->add_cap( 'administrator', 'image-hopper_edit_settings' );
		$wp_roles->add_cap( 'administrator', 'image-hopper_uninstall' );
	}

	/**
	 * Remove IH capabilities for users
	 *
	 * @return void
	 *
	 * @since 2.16
	 */
	public function remove_capabilities_from_users() {
		global $wp_roles;

		if ( class_exists( '\WP_Roles' ) ) {
			if ( ! isset( $wp_roles ) ) {
				$wp_roles = new \WP_Roles(); // phpcs:ignore
			}
		}

		if ( ! is_object( $wp_roles ) ) {
			return;
		}

		/* Remove Image Hopper capabilities to the administrator role */
		$wp_roles->remove_cap( 'administrator', 'image-hopper_edit_settings' );
		$wp_roles->remove_cap( 'administrator', 'image-hopper_uninstall' );
	}
}
