import { getAllFiles } from './getAllFiles'
import { getInputName } from './getInputName'

/**
 * @package     Image Hopper
 * @copyright   Copyright (c) 2025, Image Hopper
 * @license     https://opensource.org/licenses/gpl-3.0.php GNU Public License
 */

export function getFiles (fieldId, formId) {
  const allFiles = getAllFiles(formId)
  const inputName = getInputName(fieldId)

  if (typeof allFiles[inputName] === 'undefined') {
    allFiles[inputName] = []
  }

  return allFiles[inputName]
}

export function hasFilename (fieldId, formId, filename) {
  const files = getFiles(fieldId, formId)
  const found = files.find(file => file.uploaded_filename === filename)

  return found !== undefined
}

export function getUniqueFilename (fieldId, formId, file) {
  let filename = file.name
  let counter = 1
  while (hasFilename(fieldId, formId, filename)) {
    filename = file.basename + counter + file.extension
    counter++
  }

  return filename
}
