import $ from 'jquery'

/**
 * @package     Image Hopper
 * @copyright   Copyright (c) 2021, Image Hopper
 * @license     https://opensource.org/licenses/gpl-3.0.php GNU Public License
 */

/**
 * Ensure the {IH:1:count} field is correctly processed when files are added/removed
 *
 * @param $form jQuery form DOM
 */
export function addCalculationsSupport ($form) {
  // Process the IH "count" merge tag
  gform.addAction('gform_post_calculation_events', function (mergeTagArr, formulaField, formId, calcObj) {
    // Exclude non-IH merge tags
    if (mergeTagArr[4] !== 'count') {
      return
    }

    const fieldId = mergeTagArr[1]

    const $field = $('#field_' + formId + '_' + fieldId)
    if ($field.find('.ginput_container_image_hopper').length === 0) {
      return
    }

    $form[0].addEventListener('FilePond:updatefiles', e => {
      calcObj.bindCalcEvent(fieldId, formulaField, formId, 0)
    })
  }, 10, 4)
}

/**
 * Returns the correct value of {IH:1:count}
 *
 * @param formId
 * @param fieldId
 * @param pondObject
 */
export function processCountMergetag (formId, fieldId, pondObject) {
  gform.addFilter('gform_value_merge_tag_' + formId + '_' + fieldId, function (value, input, modifier) {
    if (modifier === 'count') {
      return pondObject.getFiles().length
    }

    return value
  }, 10, 3)
}
