/* eslint-disable */

function SetDefaultValues_image_hopper (field) {
  field.label = '%1$s'
}

function ToggleMinimumImageSize (checked) {
  const $element = jQuery('#input_minimum_dimensions')

  if (!checked) {
    SetFieldProperty('inputMinImageSizeWidth', '')
    SetFieldProperty('inputMinImageSizeHeight', '')
    jQuery('#input_minimum_width').val('')
    jQuery('#input_minimum_height').val('')
  }

  checked ? $element.show() : $element.hide()
}

function ToggleMinimumImageSizeWarning (checked) {
  const $element = jQuery('#input_minimum_warning_dimensions')

  if (!checked) {
    SetFieldProperty('inputMinImageSizeWarningWidth', '')
    SetFieldProperty('inputMinImageSizeWarningHeight', '')
    jQuery('#input_minimum_warning_width').val('')
    jQuery('#input_minimum_warning_height').val('')
  }

  checked ? $element.show() : $element.hide()
}

function ToggleUpscaleImage (checked) {
  const $upscaleImageSection = jQuery('li[class^="image_hopper_upscale_field"]')

  checked ? $upscaleImageSection.show() : $upscaleImageSection.hide()
}

jQuery(document).bind('gform_load_field_settings', function (event, field, form) {
  if (field.type === 'image_hopper') {
    jQuery('#input_maximum_width').val(field.inputWidth)
    jQuery('#input_maximum_height').val(field.inputHeight)
    jQuery('#input_maximum_files_uploaded').val(field.maxFiles)
    jQuery('#input_class_setting').val(field.inputClass)
    jQuery('#input_output_quality').val(field.outputQuality)

    // Minimum Image Sizes
    jQuery('#input_minimum_image_size').prop('checked', field.inputMinImageSize === true)
    jQuery('#input_minimum_image_size_warning').prop('checked', field.inputMinImageSizeWarning === true)

    ToggleMinimumImageSize(field.inputMinImageSize)
    ToggleMinimumImageSizeWarning(field.inputMinImageSizeWarning)

    jQuery('#input_minimum_width').val(field.inputMinImageSizeWidth)
    jQuery('#input_minimum_height').val(field.inputMinImageSizeHeight)
    jQuery('#input_minimum_warning_width').val(field.inputMinImageSizeWarningWidth)
    jQuery('#input_minimum_warning_height').val(field.inputMinImageSizeWarningHeight)
    jQuery('#input_rename_imagehopper_files').val(field.inputRenameImageHopperFiles)

    // Crop to Size
    jQuery('#input_enable_crop_to_size').prop('checked', field.cropToSize === true)

    // Upscale
    jQuery('#editor_enable_upscale_image').prop('checked', field.upscaleImageToCropSize === true)
    ToggleUpscaleImage(field.cropToSize)

    gform.doAction('image_hopper_load_field_settings', field, form)
  }

  /* Add Fileupload / Image Hopper Conversion */
  if (field.type === 'fileupload' && jQuery('#gfield_ih_convert_' + field.id).length === 0) {
    // Add new button to transform it into an Image Hopper field
    jQuery('<button id="gfield_ih_convert_' + field.id + '" class="gfield-field-action gfield-edit gfield-convert" onClick="ImageHopperConvertField(field, \'image_hopper\');" onKeyPress="ImageHopperConvertField(field, \'image_hopper\'); return false;" aria-label="%4$s"><i class="gform-icon gform-icon--post-image" style="font-size: 1.625rem;" ></i><span class="gfield-field-action__description" aria-hidden="true">%3$s</span> </button>')
      .insertAfter('#gfield_edit_' + field.id)
  }

  if (field.type === 'image_hopper' && jQuery('#gfield_ih_convert_' + field.id).length === 0) {
    // Add new button to transform it into a Fileupload field
    jQuery('<button id="gfield_ih_convert_' + field.id + '" class="gfield-field-action gfield-edit gfield-convert" onClick="ImageHopperConvertField(field, \'fileupload\');" onKeyPress="ImageHopperConvertField(field, \'fileupload\'); return false;" aria-label="%5$s"><i class="gform-icon gform-icon--consent" style="font-size: 1.625rem;" ></i><span class="gfield-field-action__description" aria-hidden="true">%3$s</span> </button>')
      .insertAfter('#gfield_edit_' + field.id)
  }
})

function ImageHopperConvertField (field, convertTo) {
  switch (convertTo) {
    case 'fileupload':
      // if single file upload field converted to and from IH without saving
      if (field.convertedSingleFileUploadToImageHopper) {
        SetFieldProperty('convertedSingleFileUploadToImageHopper', false)
        SetFieldProperty('multipleFiles', false)
      }

      SetFieldProperty('type', 'fileupload')
      SetFieldProperty('allowedExtensions', '')
      StartChangeInputType('fileupload', field);
      break

    case 'image_hopper':
      // mark single file upload field so we can post-process on form save
      if (!field.multipleFiles) {
        SetFieldProperty('convertedSingleFileUploadToImageHopper', true)
      }

      SetFieldProperty('type', 'image_hopper')
      SetFieldProperty('allowedExtensions', '%2$s')
      SetFieldProperty('multipleFiles', true)
      StartChangeInputType('image_hopper', field);
      break
  }
}