<?php

namespace ImageHopper\ImageHopper\ThirdParty\GravityPerks;

/**
 * @package     Image Hopper
 * @copyright   Copyright (c) 2025, Image Hopper
 * @license     https://opensource.org/licenses/gpl-3.0.php GNU Public License
 */

/**
 * @since 2.13.6
 */
class PageTransitions {

	private static $_instance = null;

	/**
	 * Returns an instance of this class, and stores it in the $_instance property.
	 *
	 * @return self $_instance An instance of this class.
	 *
	 * @since 2.13.6
	 */
	public static function get_instance() {
		if ( self::$_instance === null ) {
			self::$_instance = new self();
		}

		return self::$_instance;
	}

	/**
	 * @since 2.13.6
	 */
	public function init() {
		add_filter( 'gppt_script_args', [ $this, 'mask_image_hopper_field' ] );
	}

	/**
	 * Ensure Page Transition uses correct field selector in soft validation for Image Hopper
	 *
	 * @since 2.13.6
	 */
	public function mask_image_hopper_field( $args ) {

		/* expected data missing, return */
		if ( ! isset( $args['formId'], $args['validationSelectors'] ) ) {
			return $args;
		}

		/* no IH fields found, return */
		$form_id   = $args['formId'];
		$ih_fields = \GFAPI::get_fields_by_type( \GFAPI::get_form( $form_id ), [ 'image_hopper', 'image_hopper_post' ] );
		if ( empty( $ih_fields ) ) {
			return $args;
		}

		$ih_field_ids = array_column( $ih_fields, 'id' );

		/* Update IH selector for soft validation */
		foreach ( $args['validationSelectors'] as &$fields ) {
			$fields = array_map(
				static function ( $value ) use ( $ih_field_ids, $form_id ) {
					if ( isset( $value['id'] ) && in_array( $value['id'], $ih_field_ids, true ) ) {
						$value['selectors'][0] = sprintf( '#field_%d_%d input[type="file"]', $form_id, $value['id'] );
					}

					return $value;
				},
				$fields
			);
		}

		return $args;
	}
}
