import $ from 'jquery'
import { reorderFiles } from './reorderFiles'

/**
 * @package     Image Hopper
 * @copyright   Copyright (c) 2025, Image Hopper
 * @license     https://opensource.org/licenses/gpl-3.0.php GNU Public License
 */

const l10n = image_hopper_js_strings.l10n

export default function keyboardNavigation (e, pond, pondObject, fieldId, formId) {
  const key = e.key

  // Exit if element is not a list item
  if (e.target.nodeName !== 'LI') {
    return
  }

  // Exit if keyboard press is not arrow key
  if (!['ArrowLeft', 'ArrowRight', 'ArrowUp', 'ArrowDown', 'j', 'k'].includes(key)) {
    return
  }

  const files = pondObject.getFiles()
  const fileId = $(e.target).attr('id').replace('filepond--item-', '')
  const currentElement = '#' + e.target.id
  let currentIndex

  // Get current index
  files.forEach((item, index) => {
    if (item.id === fileId) {
      currentIndex = index
    }
  })

  const data = {
    e: e.target,
    files,
    pond,
    pondObject,
    currentElement,
    currentIndex,
    fieldId,
    formId
  }

  /* Up arrow & Left arrow */
  if (['ArrowLeft', 'ArrowUp', 'j'].includes(key)) {
    moveDown(data)
    e.preventDefault()
  }

  /* Down arrow & Right arrow */
  if (['ArrowRight', 'ArrowDown', 'k'].includes(key)) {
    moveUp(data)
    e.preventDefault()
  }
}

export function moveDown ({ e, files, pond, pondObject, currentIndex, currentElement, fieldId, formId }) {
  const previousIndex = currentIndex - 1

  if (previousIndex >= 0) {
    updateFilepondGF(pondObject, currentIndex, previousIndex, fieldId, formId)

    // Reorder DOM element
    $('#' + e.previousSibling.id).before($(currentElement))
    $(currentElement).trigger('focus')

    // Screen reader feedback
    updateScreenReaderFeedback(pond, files, currentIndex, currentIndex)
  }
}

export function moveUp ({ e, files, pond, pondObject, currentIndex, currentElement, fieldId, formId }) {
  const nextIndex = currentIndex + 1

  if (nextIndex < files.length) {
    updateFilepondGF(pondObject, currentIndex, nextIndex, fieldId, formId)

    // Reorder DOM element
    $('#' + e.nextSibling.id).after($(currentElement))
    $(currentElement).trigger('focus')

    // Screen reader feedback
    updateScreenReaderFeedback(pond, files, currentIndex, (nextIndex + 1))
  }
}

export function updateFilepondGF (pondObject, currentIndex, index, fieldId, formId) {
  // Update filepond items
  pondObject.moveFile(currentIndex, index)

  // Update data for GF submission
  reorderFiles(pondObject.getFiles(), fieldId, formId)
}

export function updateScreenReaderFeedback (pond, files, currentIndex, index) {
  $(pond)
    .parent()
    .find('.ih-screenreader-feedback-messages')
    .text(
      files[currentIndex].filename + '. ' +
      l10n.imageReorderActiveFeedback
        .replace('%1$s', index)
        .replace('%2$s', files.length)
    )
}
