<?php

namespace ImageHopper\ImageHopper\ThirdParty\HideMyWpGhost;

/**
 * @package     Image Hopper
 * @copyright   Copyright (c) 2025, Image Hopper
 * @license     https://opensource.org/licenses/gpl-3.0.php GNU Public License
 */

/**
 * @since 2.5.0
 * @link https://hidemywpghost.com/
 */
class FilePath {

	private static $_instance = null;

	/**
	 * Returns an instance of this class, and stores it in the $_instance property.
	 *
	 * @return self $_instance An instance of this class.
	 *
	 * @since 2.5
	 */
	public static function get_instance() {
		if ( self::$_instance === null ) {
			self::$_instance = new self();
		}

		return self::$_instance;
	}

	/**
	 * @since 2.5.0
	 */
	public function init() {
		add_action( 'image_hopper_pre_field_validation', [ $this, 'fix_path_mask' ], 10, 5 );
		add_filter( 'image_hopper_pre_get_value_save_entry', [ $this, 'fix_path_mask' ], 10, 5 );
	}

	/**
	 * Hide My WP Ghost can manipulate the URL of uploads to mask their location on the server
	 * This code ensures the masked URLs are unmasked when editing existing entries so
	 * Image Hopper can correctly determine what is a new upload, what is an existing upload,
	 * and what is an invalid upload (the masked files were considered invalid).
	 *
	 * @param mixed  $value
	 * @param array  $form
	 * @param string $input_name
	 * @param int    $lead_id
	 * @param array  $lead
	 *
	 * @return mixed
	 *
	 * @since 2.5.0
	 * @since 2.16.9 Unmask before field validation to fix GravityView validation error
	 */
	public function fix_path_mask( $value, $form, $input_name, $lead_id, $lead ) {
		static $run = [];

		/* Skip if invalid input */
		if ( ! isset( $form['id'] ) || ! is_string( $input_name ) ) {
			return $value;
		}

		$key = sprintf( '%s-%s', $form['id'], $input_name );

		/* Skip if this form field is already processed this request */
		if ( isset( $run[ $key ] ) ) {
			return $value;
		}

		$original_path = \HMWP_Classes_Tools::$default['hmwp_wp-content_url'] . '/' . \HMWP_Classes_Tools::$default['hmwp_upload_url'] . '/';
		$masked_path   = \HMWP_Classes_Tools::getOption( 'hmwp_upload_url' ) . '/';

		if ( isset( \GFFormsModel::$uploaded_files[ $form['id'] ][ $input_name ] ) ) {
			foreach ( \GFFormsModel::$uploaded_files[ $form['id'] ][ $input_name ] as &$file ) {
				$file['uploaded_filename'] = str_ireplace( $masked_path, $original_path, $file['uploaded_filename'] );
			}
		}

		$posted_files = \GFCommon::json_decode( stripslashes( \GFForms::post( 'gform_uploaded_files' ) ) );
		if ( isset( $posted_files[ $input_name ] ) ) {
			foreach ( $posted_files[ $input_name ] as &$file ) {
				$file['uploaded_filename'] = str_ireplace( $masked_path, $original_path, $file['uploaded_filename'] );
			}

			unset( $file );
		}

		$_POST['gform_uploaded_files'] = wp_json_encode( $posted_files, JSON_UNESCAPED_UNICODE );

		$run[ $key ] = true;

		return $value;
	}
}
