<?php

namespace ImageHopper\ImageHopper\ThirdParty\GravityPdf;

/**
 * @package     Image Hopper
 * @copyright   Copyright (c) 2025, Image Hopper
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 */

/**
 * @since 2.15
 */
class Fields {

	private static $_instance = null;

	/**
	 * Returns an instance of this class, and stores it in the $_instance property.
	 *
	 * @return self $_instance An instance of this class.
	 *
	 * @since 2.15
	 */
	public static function get_instance() {
		if ( self::$_instance === null ) {
			self::$_instance = new self();
		}

		return self::$_instance;
	}

	/**
	 * @since 2.15
	 */
	public function init() {

		/* Register Gravity PDF Field Rendering Classes */
		include_once __DIR__ . '/Field_Image_Hopper.php';
		include_once __DIR__ . '/Field_Image_Hopper_Post.php';

		/* Inject CSS in Core / Universal templates */
		add_action( 'gfpdf_core_template', [ $this, 'render_image_hopper_css' ] );
	}

	public function render_image_hopper_css() {
		?>
		<style>
		  .ih-image {
			object-fit: contain;
			max-height: 100%;
			max-width: 100%;
		  }

		  .ih-image-container {
			padding-bottom: 1%;
		  }

		  /* Image Hopper Column Classes */
		  .gf_list_2col .ih-image-container,
		  .gf_list_3col .ih-image-container,
		  .gf_list_4col .ih-image-container,
		  .gf_list_5col .ih-image-container {
			float: left;
			padding: 0 1% 1% 0;
			text-align: center;
		  }

		  .gf_list_2col .ih-image-container {
			width: 48%;
		  }

		  .gf_list_3col .ih-image-container {
			width: 32%;
		  }

		  .gf_list_4col .ih-image-container {
			width: 23%;
		  }

		  .gf_list_5col .ih-image-container {
			width: 18%;
		  }
		</style>
		<?php
	}
}
