<?php

namespace ImageHopper\ImageHopper\FirstParty;

/**
 * @package     Image Hopper
 * @copyright   Copyright (c) 2025, Image Hopper
 * @license     https://opensource.org/licenses/gpl-3.0.php GNU Public License
 */

/**
 * @since 2.12
 */
class Zapier {

	/**
	 * @var object $_instance If available, contains an instance of this class.
	 *
	 * @since 2.12
	 */
	private static $_instance = null;

	/**
	 * Returns an instance of this class, and stores it in the $_instance property.
	 *
	 * @return self $_instance An instance of this class.
	 *
	 * @since 2.12
	 */
	public static function get_instance() {
		if ( self::$_instance === null ) {
			self::$_instance = new self();
		}

		return self::$_instance;
	}

	/**
	 * @since 2.12
	 */
	public function init() {
		add_filter( 'gform_zapier_request_body', [ $this, 'enhance_zapier_data' ], 10, 4 );
	}

	/**
	 * Decode the Image Hopper fields and pass along the content in a more readily accessible format.
	 *
	 * @param array $body
	 * @param array $feed
	 * @param array $entry
	 * @param array $form
	 *
	 * @return array
	 *
	 * @since 2.12
	 */
	public function enhance_zapier_data( $body, $feed, $entry, $form ) {
		$zapier       = \GF_Zapier::get_instance();
		$admin_labels = is_array( $feed ) ? rgars( $feed, 'meta/adminLabels' ) : false;

		$ih_fields = \GFAPI::get_fields_by_type( $form, [ 'image_hopper', 'image_hopper_post' ] );

		foreach ( $ih_fields as $field ) {
			$field_label = $zapier->get_body_label( $admin_labels, $field );
			$field_value = $field->get_value_export( $entry );

			if ( empty( $field_value ) ) {
				continue;
			}

			switch ( $field->type ) {
				case 'image_hopper':
					/* Add comma-separated list */
					$key          = $zapier->get_body_key( $body, $field_label . ' Decoded' );
					$body[ $key ] = $field_value;

					/* Add array */
					$key          = $zapier->get_body_key( $body, $field_label . ' Array' );
					$body[ $key ] = explode( ' , ', $field_value );
					break;

				case 'image_hopper_post':
					$field_value = explode( '|:|', $field_value );

					$body[ $zapier->get_body_key( $body, $field_label . ' URL' ) ]         = isset( $field_value[0] ) ? $field_value[0] : '';
					$body[ $zapier->get_body_key( $body, $field_label . ' Title' ) ]       = isset( $field_value[1] ) ? $field_value[1] : '';
					$body[ $zapier->get_body_key( $body, $field_label . ' Caption' ) ]     = isset( $field_value[2] ) ? $field_value[2] : '';
					$body[ $zapier->get_body_key( $body, $field_label . ' Description' ) ] = isset( $field_value[3] ) ? $field_value[3] : '';
					$body[ $zapier->get_body_key( $body, $field_label . ' Alt' ) ]         = isset( $field_value[4] ) ? $field_value[4] : '';
					break;
			}
		}

		return $body;
	}
}
