/**
 * @package     Image Hopper
 * @copyright   Copyright (c) 2025, Image Hopper
 * @license     https://opensource.org/licenses/gpl-3.0.php GNU Public License
 */

export function prepareTmpFilesForPond (files) {
  if (!Array.isArray(files)) {
    return []
  }

  const pondFiles = []

  files.forEach((file) => {
    const tmpFilename = file.temp_filename
    if (tmpFilename === null || tmpFilename === undefined || (file.status && file.status === 'placeholder')) {
      return
    }

    const type = file.temp_filename.length > 0 ? 'limbo' : 'local'

    pondFiles.push({
      source: type === 'limbo' ? file.temp_filename : file.uploaded_filename,
      options: {
        type
      }
    })
  })

  return pondFiles
}
