/**
 * @package     Image Hopper
 * @copyright   Copyright (c) 2025, Image Hopper
 * @license     https://opensource.org/licenses/gpl-3.0.php GNU Public License
 */

export function prepareSavedFilesForPond (files) {
  // convert object with out-of-order keys to an array
  if (typeof files === 'object') {
    files = Object.values(files)
  }

  if (!Array.isArray(files)) {
    if (typeof files !== 'string' || files.length === 0) {
      return []
    }

    files = [files]
  }

  const pondFiles = []

  files.forEach((file) => {
    pondFiles.push({
      source: file,
      options: {
        type: 'local'
      }
    })
  })

  return pondFiles
}
