<?php
/**
 * Plugin Name:     Image Hopper for Gravity Forms
 * Plugin URI:      https://imagehopper.tech
 * Description:     An optimized Image Uploader for Gravity Forms. Image Hopper supports Gravity PDF, Gravity Flow, GravityView, WooCommerce Gravity Forms add-on, and Gravity Perk Nested Forms.
 * Author:          Image Hopper
 * Author URI:      https://imagehopper.tech
 * Update URI:      https://imagehopper.tech
 * Text Domain:     image-hopper
 * Domain Path:     /languages
 * Version:         2.17.0
 * Requires at least: 5.2
 * Requires PHP:    5.6
 */

/**
 * @package     Image Hopper
 * @copyright   Copyright (c) 2025, Image Hopper
 * @license     https://opensource.org/licenses/gpl-3.0.php GNU Public License
 */

/* Exit if accessed directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/* If the plugin has been activated already, deactivate the original */
if ( defined( 'IMAGE_HOPPER_ADDON_FILE' ) ) {
	deactivate_plugins( plugin_basename( IMAGE_HOPPER_ADDON_FILE ), true );

	return;
}

define( 'IMAGE_HOPPER_ADDON_VERSION', '2.17.0' );
define( 'IMAGE_HOPPER_ADDON_FILE', __FILE__ );
define( 'IMAGE_HOPPER_ADDON_PATH', plugin_basename( __FILE__ ) );

require __DIR__ . '/vendor/autoload.php';

/* When Gravity Forms loads, we'll load */
add_action( 'gform_loaded', [ 'Image_Hopper_Gravity_Forms_AddOn_Bootstrap', 'load' ], 5 );

/**
 * Class Image_Hopper_Gravity_Forms_AddOn_Bootstrap
 *
 * @since 1.0.0
 */
if ( ! class_exists( ' Image_Hopper_Gravity_Forms_AddOn_Bootstrap' ) ) {
	class Image_Hopper_Gravity_Forms_AddOn_Bootstrap {

		/**
		 * @since 1.0.0
		 */
		public static function load() {

			if ( ! method_exists( 'GFForms', 'include_addon_framework' ) ) {
				return;
			}

			GFForms::include_addon_framework();
			require_once __DIR__ . '/src/bootstrap.php';

			/* Use Bootstrap override if GravityKit distribution */
			$gravitykit_distribution_file = __DIR__ . '/src/bootstrap-gravitykit.php';
			if ( apply_filters( 'image_hopper_allow_gravitykit_startup', true ) && is_file( $gravitykit_distribution_file ) ) {
				define( 'IMAGE_HOPPER_ADDON_GRAVITYKIT', true );

				require_once $gravitykit_distribution_file;

				GFAddOn::register( '\ImageHopper\ImageHopper\ImageHopperAddOnGravityKit' );
			} else {
				GFAddOn::register( '\ImageHopper\ImageHopper\ImageHopperAddOn' );
			}
		}
	}
}

/* Add Image Hopper capabilities to administrator user on plugin activation */
register_activation_hook(
	IMAGE_HOPPER_ADDON_FILE,
	function () {
		( \ImageHopper\ImageHopper\FirstParty\Capabilities::get_instance() )->add_capabilities_to_users();
	}
);
