# Changelog

## Image Hopper

### 2.17.0
* 🎉 Feature: Add Dynamic Population setting support to Image Hopper fields (GF 2.9.18+)
* 🎉 Feature: Gravity Forms REST API form submissions support for saving Image Hopper field images (GF 2.9.18+) 
* 🧹Add Gravity Forms 2.9.18 compatibility
* 🐞 Bug: Paste from Clipboard fix when Image Hopper is used in Gravity Wiz Nested Forms
* 🐞 Bug: Resolve potential Javascript error when removing files
* 🐞 Bug: Resolve regression that caused an image validation error when running Hide My WP
* 🐞 Bug: Gracefully handle entry data that may be in an unexpected format

### 2.16.8
* 🐞 Bug: Fix file extension/mime mismatch that could occur if an error is encountered during HEIC image conversion
* 🐞 Bug: When editing an entry, display an error if a file has been deleted from the filesystem
* 🐞 Bug: Resolve saving issue when using GravityView to edit an entry and all files in a field are deleted
* 🧹 Housekeeping: Update HEIC image conversion library to improve memory and performance

### 2.16.7
* 🐞 Bug: Prevent images being stuck in an infinite loading cycle if a CORS error occurs when editing existing entries 

### 2.16.6
* 🐞 Bug: Fix issue preventing Image Paste feature working on single-page forms

### 2.16.5
* 🐞 Bug: Resolve validation error for images under the maximum upload size when the web server limits files to less than 1MB
* 🧹 Housekeeping: Additional server-side error checking when uploading files

### 2.16.4
* 🐛 Bug: Fix PHP error during form submission if running older version of Gravity Forms (pre-2.9.3)
* 🐛 Bug: Fix required and file extension validation errors when images offloaded to Dropbox using Gravity Forms Dropbox add-on
* 🐛 Bug: Fix PHP warning on the Entry Details page if images are offloaded to Dropbox
* 🐛 Bug: Ensure correct version of GravityView is targeted when applying backwards-compatibility validation logic (pre-2.40)
* 🧹 Housekeeping: Escape HTML in translated validation string
* 🧹 Housekeeping: Update translations

### 2.16.3
* 🧹 Housekeeping: Display all preloaded images and include a validation error when over the max files limit
* 🧹 Housekeeping: Improve required and max files server-side validation
* 🧹 Housekeeping: Improve compatibility with GravityView's Edit Entry feature (thanks GravityKit team!)
* 🧹 Housekeeping: Improve translations

### 2.16.2
* 🐛 Bug: Fix mergetag modifier conflict with GravityView so `{Image Hopper:4:url,urlencode}` returns the expected value

### 2.16.1
* 🐛 Bug: Prevent IH Post Image being deleted when editing an entry with GravityView
* 🐛 Bug: Fix an unexpected Image Hopper field validation error when editing an entry with GravityView

### 2.16.0
* 🎉 Feature: Register unique user capability for managing the plugin settings `image-hopper_edit_settings` and using the plugin uninstaller `image-hopper_uninstall`
* 🧹 Housekeeping: Add fallback form ID lookup when processing Image Hopper fields during new Gravity Forms submission flow
* 🧹 Housekeeping: Clear Filepond input values in new Gravity Forms submission flow
* 🐛 Bug: Add translation for the Upscale setting description
* 🐛 Bug: Prevent multiple versions of the plugin from being activated at the same time
* 🐛 Bug: Fix edge case where the Image Hopper field wouldn't initialize under very specific circumstances
* 🐛 Bug: Add fallback submission check during when the primary form ID lookup returns undefined during new Gravity Forms submission flow

### 2.15.0
* 🎉 Feature: Display image grid in Gravity PDF document if Image Hopper field includes the CSS Ready Class `gf_list_2col`, `gf_list_3col`, `gf_list_4col`, or `gf_list_5col`.
* 🎉 Feature: Add Dutch translations
* 🧹 Housekeeping: Relicense plugin from GPLv2 to GPLv3
* 🧹 Housekeeping: Replace `heic2any` dependency with `heic-to`
* 🧹 Housekeeping: Update dependencies
* 🐛 Bug: Adjust pre-form submission filter priority to prevent potential conflict with Gravity PDF Previewer

### 2.14.1
* 🐛 Bug: Fix local avatar saving issue with Gravity Forms User Registration v5.3.1+
* 🐛 Bug: Fix error rendering IH Post Image field if running legacy PHP v5.6 or PHP v7.0

### 2.14.0
* 🎉 Feature: Add Orbital Theme support to Image Hopper in the Form Editor
* 🎉 Feature: Add support for Gravity Forms new form submission processes
* 🧹 Housekeeping: Improve performance by only initialize Image Hopper fields when they are shown in the viewport
* 🧹 Housekeeping: Don't unload Image Hopper between form pages
* 🐛 Bug: Fix display of individual images on Entry Details page
* 🐛 Bug: Fix Image Hopper field validation error in Gravity Forms 2.9.3
* 🐛 Bug: Fix IH Post Image field validation error in Gravity Forms 2.9.3
* 🐛 Bug: Fix IH Post Image field validation error when using soft validation feature from Gravity Wiz Page Transition perk

### 2.13.9
* 🐛 Bug: Fix issue with images appearing squashed in email notifications
* 🐛 Bug: Force the Camera and Media picker apps to be presented to users when uploading images (workaround for Chrome on Android bug)

### 2.13.7
* 🐛 Bug: Fix PHP error when license check fails
* 🐛 Bug: Fix PHP notices when invalid license is entered
* 🧹 Housekeeping: Add debug logs for the license check API

### 2.13.6
* 🐛 Bug: Fix soft validation error on Image Hopper field that has a file uploaded when using Gravity Wiz Page Transitions perk
* 🐛 Bug: Fix Javascript error when reordering images
* 🧹 Housekeeping: Improve performance by removing Javascript resize observers when field is unloaded on multipage form
* 🧹 Housekeeping: Remove dynamically generated HTML mark-up when field is unloaded on multipage form
* 🧹 Housekeeping: Add `image_hopper_field_input_type` and `image_hopper_post_image_field_input_type` PHP filters

### 2.13.5
* 🐛 Bug: Fix Javascript error when using Gravity Wiz Page Transitions perk
* 🧹 Housekeeping: Update package dependencies to the latest version

### 2.13.4
* 🐛 Bug: Fix PHP errors when using Gravity Forms Stripe + User Registration add-ons with Image Hopper

### 2.13.3
* 🐛 Bug: Do maximum file size validation after image processing is completed
* 🐛 Bug: Fix order of files when an image is edited
* 🐛 Bug: Fix PHP error when using WooCommerce GF Product add-on with Gravity PDF Previewer
* 🐛 Bug: Fix large image display issue when using Gravity Wiz Entry Block perk
* 🐛 Bug: Fix duplicate image bug when using rename feature with WooCommerce Gravity Forms Product add-on
* 🐛 Bug: Fix form validation error when uploading images with an uppercase .HEIC file extension
* 🐛 Bug: Fix field display issue when using Gravity Wiz Page Transition perk + soft validation
* 🧹 Housekeeping: Don't clip images when displayed in the Entry Details admin page
* 🧹 Housekeeping: When standard Image Hopper files are displayed by Gravity Forms (Core) include width/height attribute in markup
* 🧹 Housekeeping: Improve security

### 2.13.2
* 🐛 Bug: Fix problem renaming files when using the `gform_upload_path` filter with an alternate URL
* 🐛 Bug: Resolve .heic image upload issue on non-iOS devices

### 2.13.1
* 🐛 Bug: Fix PHP error when Gravity Forms Dropbox and User Registration add-ons are enabled on a form

### 2.13.0
* 🎉 Feature: Single File Upload field can be converted to Image Hopper field in the Form Editor
* 🎉 Feature: Image Hopper fields are displayed as a uniform grid on the Entry Details admin page
* 🎉 Feature: IH Post Image fields will be displayed at full size (for the available space) on the Entry Details admin page
* 🎉 Feature: Accept .avif image uploads when running WordPress 6.5+. Note: browsers cannot yet create .avif files; when they are manipulated (downscaled/cropped) a browser will output the image in a supported format (usually .png).
* 🎉 Feature: Gravity PDF will display .webp and .avif Image Hopper images (when the web server supports it)
* 🎉 Feature: Gravity PDF will display the hyperlink/filename for non-image file types
* 🎉 Feature: Add support for GravityView's Advanced Filtering add-on
* 🔒 Security: Improve security of network requests to licensing server
* 🧹 Housekeeping: Exclude popular WordPress staging environments from site count when activating license key
* 🧹 Housekeeping: Improve license activation success and error messages
* 🧹 Housekeeping: Cache results of license API requests for improved performance
* 🧹 Housekeeping: Resolve PHP notice when license key does not exist in the database
* 🧹 Housekeeping: Add missing `multiple` HTML attribute to file upload field, when required
* 🧹 Housekeeping: Add focus outline to delete/revert/edit action buttons
* 🧹 Housekeeping: Update JavaScript packages
* 🐛 Bug: Gracefully handle 'known image' error when doing .heic conversion
* 🐛 Bug: Exclude JavaScript assets from Siteground Speed Optimizer minifier feature
* 🐛 Bug: Fix the 'upload in progress' alert from showing on form submission when image validation fails

### 2.12.0
* 🎉 Feature: Enhance Gravity Forms Webhook data for Image Hopper and Post Image Hopper fields
* 🎉 Feature: Enhance Gravity Forms Zapier data for Image Hopper field

### 2.11.0
* 🎉 Feature: Support for Gravity Forms 2.8 Orbital Theme
* 🎉 Feature: Support for Gravity Forms 2.8 Compact Mode
* 🎉 Feature: Add full IH Post Image support to Gravity PDF
* 🧹 Housekeeping: Don't transform image if output quality is left empty and resizing not required
* 🧹 Housekeeping: Retain EXIF data when transforming images
* 🧹 Housekeeping: Improve accessibility for screen readers
* 🧹 Housekeeping: Fix jQuery deprecation notices
* 🧹 Housekeeping: Improve security
* 🐛 Bug: Fix fatal error when using Stripe Payment Elements in a form with Image Hopper fields
* 🐛 Bug: Ensure Output Quality is always within 1-100 range when transforming images

### 2.10.2
* 🐛 Bug: Fix WooCommerce Gravity Forms Product add-on compatibility issue offloading Image Hopper uploads to Dropbox

### 2.10.1
* 🐛 Bug: Ensure trailing slash is always added to the path when renaming uploads

### 2.10.0
* 🎉 Feature: User-defined file renaming for Standard and Post Image Hopper fields. Merge tags are supported. Relative directories are supported for Standard Image Hopper fields (relative to the form's uploads directory).
* 🎉 Feature: Allow valid unicode file names in Post Image Hopper fields
* 🎉 Feature: Display images containing valid unicode file names in GravityView
* 🐛 Bug: Correctly set field settings when converting back and forth between Post Image and IH POst Image fields
* 🐛 Bug: Correctly handle unicode file names when checking for images to deleted
* 🐛 Bug: Prevent Minimum Image Size Warning from being removed when Upscale Image setting is enabled
* 🐛 Bug: Disregard URL query parameters and fragments when checking for an image file extension
* 🐛 Bug: Correctly display offloaded Dropbox image files

### 2.9.1
* 🐛 Bug: Prevent user confusion by never showing "100%" in the upload progress indicator

### 2.9.0
* 🎉 Feature: Add Conversational Forms Add-on Support (https://docs.gravityforms.com/using-the-conversational-forms-add-on/)
* 🎉 Feature: Add Orbital Theme Support (https://docs.gravityforms.com/block-themes-and-style-settings/)
* 🧹 Housekeeping: Adjust small three-column layout lower threshold from 900px to 700px
* 🧹 Housekeeping: Adjust medium two-column layout lower threshold from 650px to 450px
* 🔒 Security: Improve input / output sanitization and escaping

### 2.8.6
* 🐛 Bug: Resolve issue processing images when updating an existing post with Advanced Post Creation (Requires APC v1.3.3+)

### 2.8.5
* 🐛 Bug: Ignore image protocol (http/https) when reordering images

### 2.8.4
* 🧹 Housekeeping: Add German (Formal) translations

### 2.8.3
* 🐛 Bug: Ignore image protocol (http/https) when checking for images to delete
* 🐛 Bug: Ignore file extension case (eg .jpg vs .JPG) when outputting Image Hopper on Entry Details

### 2.8.2
* 🐛 Bug: Prevent PHP Error when the Partial Entry add-on "heartbeat" is triggered to save the entry
* 🐛 Bug: Fix conflict with Weglot plugin auto-redirect feature when uploading images

### 2.8.1
* 🐛 Bug: Fix form submission issue if dropping a replacement image when the Max Files limit is reached
* 🐛 Bug: Add maximum preview width so the UI doesn't become unwieldy on large screens

### 2.8.0
* 🎉 Feature: File Upload and Post Image fields can be converted to Image Hopper fields in the Form Editor
* 🐛 Bug: Resolve PHP notice when saving an existing entry

### 2.7.2
* 🐛 Bug: Resolve image order issue when using GravityView's Edit Entry feature with Image Hopper Editor

### 2.7.1
* 🐛 Bug: Resolve conflict with the User Registration add-on and the image editor when re-saving pre-loaded images
* 🐛 Bug: Resolve PHP 8.1 notice

### 2.7.0
* 🎉 Feature: Add Hide My WP Support (https://codecanyon.net/item/hide-my-wp-amazing-security-plugin-for-wordpress/4177158)
* 🐛 Bug: Fix issue with existing images getting removed in Gravity Flow due to change in file validation in recent Gravity Forms 2.7.1 update.

### 2.6.0
* 🎉 Feature: Add Gravity Forms 2.7 Orbital Theme Compatibility
* 🐛 Bug: Resolve a number of URL encoding/decoding issues to ensure images are correctly grouped into new, existing, and  deleted images when editing entries

### 2.5.0
* 🎉 Feature: Add Hide My WP Ghost Support (https://hidemywpghost.com/)
* 🎉 Feature: Add wpDataTables Support
* 🎉 Feature: Add more descriptive license activation / validation messages
* 🐛 Bug: Fix CORS issue when loading JavaScript files from a CDN
* 🐛 Bug: Fix GravityView Edit + IH Post Image validation and saving problem

### 2.4.5
* 🐛 Bug: Fix image delete/removal regression caused by cache busting introduced in 2.4.4

### 2.4.4
* 🐛 Bug: Fix image saving issue after editing an existing entry's image + reordering
* 🐛 Bug: Fix issue where cached image may be shown while editing entries

### 2.4.3
* 🐛 Bug: Resolve issue passing Image Hopper data when using the Add Entry, Update Entry, and Update Fields Gravity Flow Form Connector plugin steps

### 2.4.2
* 🧹 Housekeeping: Create public delete_file() method on the field object

### 2.4.1
* 🐛 Bug: Fix Image Hopper Max File validation problem when editing GravityView entries

### 2.4.0
* 🎉 Feature: When editing entries, delete stored image(s) from server upon form submission instead of instantly.
* 🐛 Bug: Fix invalid foreach warning on form submission when using Post IH field

### 2.3.4.1
* 🧹 Housekeeping: Prevent the browser jumping directly to an image after an upload is complete

### 2.3.4
* 🐛 Bug: Fix another edge-case problem uploading different images that have the same filename

### 2.3.3
* 🐛 Bug: Fix problem uploading different images that have the same filename

### 2.3.2
* 🐛 Bug: Fix .heic validation problem on Windows machines
* 🧹 Housekeeping: Upgrade .heic to JPG image conversion library
* 🧹 Housekeeping: Upgrade Filepond and Plugin packages to latest version

### 2.3.1
* 🐛 Bug: Ensure Image Hopper fields are displayed correctly in Gravity PDF when document is manually generated during the `init` hook.
* 🐛 Bug: Resolve conflict editing Image Hopper fields when used in combination with GravityView's edit entry feature and Gravity Perks Media Library.
* 🐛 Bug: Allow images to be attached to notification email when using a different upload path

### 2.3.0
* 🎉 Feature: Add new {Image Hopper:1:count} merge tag which returns the number of images uploaded, and can be used in calculations to do "pay per image" billing
* 🎉 Feature: Use any Image Hopper field with the Advanced Post Creation Featured Image setting (previously only worked if the IH field had Max Files set to 1).
* 🧹 Housekeeping: Update all package dependencies to the latest version
* 🧹 Housekeeping: Implement "Update URI" plugin slug to prevent possible wordpress.org update from a plugin with the same slug
* 🐛 Bug: Only include screenreader accessibility instructions when image reordering is enabled
* 🐛 Bug: Fix image prefilling issue on multipage forms when editing an entry

### 2.2.7
* 🐛 Bug: Better handle malformed JSON and catch JSON parsing errors so the UI doesn't lock up on upload
* 🐛 Bug: Lower the visibility check threshold so the Image Hopper field renders more promptly as users scroll

### 2.2.6
* 🐛 Bug: Set the settings page access to users with the gravityforms_edit_settings capability to fix access issues

### 2.2.5
* 🐛 Bug: Fix regression introduced in 2.2.4 for the Gravity Wiz Nested Perks add-on that prevented the field being initialized

### 2.2.4
* 🐛 Bug: Fix issue rendering Image Hopper field if Gravity Forms is hidden on page load eg. inside accordion/tab/popup

### 2.2.3
* 🐛 Bug: Ensure Facebook/Instagram in-built browser app can select and upload all image types
* 🐛 Bug: Correctly display UTF-8 filenames on form validation error

### 2.2.2
* 🐛 Bug: Fix WooCommerce Gravity Forms validation issue when Image Hopper is a required field
* 🐛 Bug: Fix WooCommerce Gravity Forms image reorder issue when editing an entry after adding to cart

### 2.2.1
* 🐛 Bug: Fix issue uploading images when conditional logic enabled on Image Hopper fields and the default state on form loading for that field is "hide"

### 2.2.0
* 🎉 Feature: Full support for the User Registration add-on. When using the "Update User" feed with images linked to user meta, those images will auto-populate and correctly saved back to the user meta.
* 🎉 Feature: Support for the Simple Local Avatars, WP User Avatars, and Basic User Avatars plugins with the User Registration add-on
* 🎉 Feature: A better image viewing experience when Image Hopper field has a 1-image upload limit
* 🎉 Feature: Add support for iOS .heic image uploads (automatically converting them to .jpg)
* 🎉 Feature: Pre-populated images will be correctly saved with the entry if those images are on the same domain (use `image_hopper_allowed_prepopulated_url` to allow alternate domains)
* 🐛 Bug: Fix Nested Forms display issue when adding new images to Image Hopper fields

### 2.1.1
* 🐛 Bug: Ensure deleted images are correctly removed when using the Save and Continue feature
* 🐛 Bug: Fix conflict with the Save and Continue feature when the Dropbox add-on is active

### 2.1.0
* 🎉 Feature: Add Gravity Forms Dropbox add-on support
* 🎉 Feature: Add enhanced Gravity Forms Zapier add-on support
* 🎉 Feature: Add Chinese (simple), Russian, and Hebrew translations
* 🐛 Bug: Display server-side validation errors, if triggered
* 🐛 Bug: Fix GravityView render issue for Image Hopper fields
* 🐛 Bug: Fix webp upload issue on multisite installations
* 🐛 Bug: Prevent unnecessary image transformations
* 🐛 Bug: Use the gform_unique_id when handling images instead of extracting from the filename
* 🧑‍💻 Developer: Add additional log messages when images are uploaded to assist with debugging

### 2.0.0
* 🎉 Feature: Add support for Image Hopper Editor 2.0
* 🎉 Feature: Add support for BMP and WebP images
* 🎉 Feature: Reduce JavaScript bundle size by 16kb
* 🐛 Bug: Disable image reorder enhancements when turned off via code
* 🐛 Bug: Display correct order when an image is drag and dropped
* 🐛 Bug: Allow image to be deleted from the UI if an invalid form/entry combo is provided
* 🐛 Bug: Fix issue with form submitting while images are still uploading under specific circumstances
* 🐛 Bug: Automatically remove invalid files before submission to prevent invalid state
* ⚠️ BREAKING CHANGE: Remove Internet Explorer support. New minimum browsers supported: Microsoft Edge 18+, Safari/iOS Safari 10.1+, Chrome 61+, Firefox 60+, Opera 48+, Android 61+
* ⚠️ BREAKING CHANGE: Move a number of strings from the `default` and `gravityforms` translation namespace to `image-hopper`. This change would only affect users with custom translations, and only if they've modified particular strings.

### 1.5.1
* 🐛 Bug: Prevent invalid image state when using Save and Continue feature or navigating multi-page forms
* 🐛 Bug: Remove temporary ID from filename when using Save and Continue feature or navigating multi-page forms
* 🧹 Housekeeping: Add logging information to delete, revert, and restore Image Hopper API

### 1.5.0
* 🎉 Feature: Add Minimum Image Size Restriction setting
* 🎉 Feature: Add Minimum Image Size Warning setting
* 🎉 Feature: Add automatic image crop and upscale image to crop dimensions settings (moved from Editor add-on)
* 🎉 Feature: Add support for GravityView Import Entries
* 🎉 Feature: Enhanced GravityView support when configuring Image Hopper fields in a view
* 🎉 Feature: Prettify the Image Hopper fields in the Form Editor and in Gutenberg Editor
* 💯 Performance: Remove minimum 750ms upload time per file
* 💯 Performance: Reduce JavaScript bundle size and drop Internet Explorer 11 support
* 🐛 Bug: Fix PHP Notice on form Notification settings page
* 🐛 Bug: Fix counter accuracy that tracks current images being uploaded
* 🐛 Bug: Fix special character encoding issue in filename
* 🐛 Bug: Correctly render default Image Hopper merge tag on Confirmation page
* 🐛 Bug: Display individual URLs on a new line when in HTML context using the :url and :raw merge tag modifiers
* 🐛 Bug: Fix fatal error when saving the Advanced Post Creation feed

### 1.4.1
* 🐛 Bug: Ensure images can be attached to Notification emails in Gravity Forms 2.5

### 1.4.0
* 🎉 Feature: Gravity Forms 2.5 (GF2.5) Support
* 🎉 Feature: Add unique icon for Image Hopper (IH) add-on and fields for GF2.5
* 🎉 Feature: Add accessibility improvements for IH Post Image field in GF2.5
* 🎉 Feature: Show clearer license key status below IH license key field on settings page
* 🐛 Bug: Fix IH Post Image field display issues in GF2.5 (credit Aaron Roessler)
* 🐛 Bug: Add padding for radio and checkboxes in GF2.5 Form Editor IH fields
* 🐛 Bug: Catch exception if IH fields already registered in Gravity Forms. Resolves a fatal error in Import Entries GravityView add-on
* 🐛 Bug: Fix flash of unstyled content during form submission for Image Hopper fields (credit Aaron Roessler)
* 🐛 Bug: Ensure associated IH files are deleted when entries are deleted
* 🐛 Bug: Fix max upload size validation issue when using server-defined limit
* 🐛 Bug: Standardize font size in Image Hopper and fix text overflow due to poorly-sized images

### 1.3.0
* 🎉 Feature: Add native Image Hopper Post Image field
* 🎉 Feature: Add Gravity Forms + Custom Post Type add-on support (via the new Post Image field)
* 🎉 Feature: Add Gravity Forms Advanced Post Creation add-on support
* 🎉 Feature: Add Gravity Wiz Media Library add-on support
* 🎉 Feature: Display an error message if a user tries to add more images than the Image Hopper field allows
* 🐛 Bug: Gravity PDF Previewer: ensure it auto-refreshes the PDF preview when Image Hopper fields are modified
* 🐛 Bug: WooCommerce Gravity Forms: Display thumbnail-size images in the WooCommerce checkout
* 🐛 Bug: WooCommerce Gravity Forms: Allow uploaded images to be deleted while editing entry
* 🐛 Bug: GravityView: Adjust permissions to allow images to be deleted by the entry owner
* 🐛 Bug: Fix Image Hopper display issues on RTL-enabled sites
* 🐛 Bug: Correctly escape HTML when converting mergetags (when needed)
* 🐛 Bug: Resolve image loading issue for servers with GZIP compression enabled
* 🐛 Bug: Reduce memory footprint for better performance on low-powered devices
* 🐛 Bug: Better handle image loading errors so Image Hopper doesn't lock the form in a bad state
* 🐛 Bug: Fix up JavaScript syntax issue on the Form Editor page

### 1.2.0
* 🎉 Feature: Add translations for German (de_DE), French (fr_FR) and Spanish (es_ES)
* 🐛 Bug: Purge the plugin update transient after license activation

### 1.1.0
* 🎉 Feature: Add "Output Quality" setting to Image Hopper field, allowing you to reduce the quality of images.
* 🐛 Bug: Fix image display issue in Core/Universal Gravity PDF templates when image height too large to fit on a single page
* 🐛 Bug: Fix image loading issue in Core/Universal Gravity PDF templates when WordPress cannot perform a loopback request.
* 🐛 Bug: Ensure "Attach uploaded files to notification" setting is shown on the Notifications page when Image Hopper field present in form
* 🐛 Bug: Disable "Paste Image" feature if multiple Image Hopper fields displayed on the same page. This prevents the image being pasted into multiple Image Hopper fields at the same time. Feature is still enabled if a single Image Hopper field is shown on the page.
* 🧹 Housekeeping: Add tooltip to the "Downscale Image" setting that includes references to common aspect ratio and the equivalent value in pixels.
* 🧑‍💻 Developer: Add `image_hopper_filepond_plugin_registration` JavaScript action to allow additional Filepond plugins to be registered
* 🧑‍💻 Developer: Add `image_hopper_pre_filepond_create` JavaScript action to allow Filepond to be configured before current field is initialized
* 🧑‍💻 Developer: Add `image_hopper_post_filepond_create` JavaScript action to allow Filepond to be configured after current field is initialized
* 🧑‍💻 Developer: Add `image_hopper_filepond_config` JavaScript filter to allow Filepond configuration settings to be modified
* 🧑‍💻 Developer: Add `image_hopper_global_setting_fields` PHP filter to allow Image Hopper global settings to be modified
* 🧑‍💻 Developer: Add `image_hopper_plugin_updater` PHP action to allow code to be triggered when the plugin updater code is initialized
* 🧑‍💻 Developer: Add `image_hopper_enabled_field_settings` PHP filter to allow Image Hopper field settings to be modified
* 🧑‍💻 Developer: Add `image_hopper_inline_javascript` PHP filter to allow Image Hopper field editor inline JavaScript to be modified
* 🧑‍💻 Developer: Add `image_hopper_input_field` PHP filter to allow Image Hopper field HTML mark-up to be modified
* 🧑‍💻 Developer: Add `image_hopper_pre_get_value_save_entry` PHP filter to allow field value to be modified before being saved in the entry
* 🧑‍💻 Developer: Add `image_hopper_post_get_value_save_entry` PHP filter to allow field value to be modified after being saved in the entry

### 1.0.2
* 🐛 Bug: Resolve issue with Image Hopper field when displaying two Gravity Forms on the same page
* 🐛 Bug: Prevent Image Hopper field loading when form Text Confirmation is displayed

### 1.0.1

* 🎉 Feature: Show image output when using field merge tag, add :url and :raw modifiers.
* 🐛 Bug: Fix PHP error due to namespacing the licensing code
* 🐛 Bug: Fix licensing check issue due to incorrect plugin slug passed
* 🐛 Bug: Remove the two polyfilled Slim field buttons from the form editor
* 🐛 Bug: Prevent images running on each other when displayed by adding 5px padding
* 🐛 Bug: Fix encoding issue with the delete alert message

### 1.0.0

* 🎉 Initial Release