import $ from 'jquery'

/**
 * @package     Image Hopper
 * @copyright   Copyright (c) 2025, Image Hopper
 * @license     https://opensource.org/licenses/gpl-3.0.php GNU Public License
 */

export function deleteFile (formId, fieldId, filename) {
  const $uploads = $('#gform_uploaded_files_' + formId)
  const filesJson = $uploads.val()

  if (filesJson) {
    const files = $.secureEvalJSON(filesJson)

    if (files) {
      const fileIndex = files['input_' + fieldId].findIndex((file) => {
        return file.temp_filename === filename || file.uploaded_filename === filename
      })

      if (fileIndex !== -1) {
        files['input_' + fieldId].splice(fileIndex, 1)
        $uploads.val($.toJSON(files))
      }
    }
  }
}
