<?php

namespace ImageHopper\ImageHopper\ThirdParty\WpDataTables;

/**
 * @package     Image Hopper
 * @copyright   Copyright (c) 2025, Image Hopper
 * @license     https://opensource.org/licenses/gpl-3.0.php GNU Public License
 */

/**
 * @since 2.5.0
 */
class GravityForms {

	private static $_instance = null;

	/**
	 * Returns an instance of this class, and stores it in the $_instance property.
	 *
	 * @return self $_instance An instance of this class.
	 *
	 * @since 2.5
	 */
	public static function get_instance() {
		if ( self::$_instance === null ) {
			self::$_instance = new self();
		}

		return self::$_instance;
	}

	/**
	 * @since 2.5.0
	 */
	public function init() {
		add_action(
			'wpdatatables_generate_gravity',
			function() {
				add_filter( 'gform_form_post_get_meta', [ $this, 'masquerade_fields' ] );
			},
			1
		);

		if ( wp_doing_ajax() && rgpost( 'action' ) === 'wdt_save_gf_table_frontend' ) {
			add_filter( 'gform_form_post_get_meta', [ $this, 'masquerade_fields' ] );
		}

	}

	/**
	 * Force Image Hopper fields to have fileupload or post_image field types
	 * This ensures WP Data Tables applies the same formatting to Image Hopper fields
	 * as it does to File Upload / Post Image fields.
	 *
	 * @param array $form
	 *
	 * @return array
	 *
	 * @since 2.5.0
	 */
	public function masquerade_fields( $form ) {
		foreach ( $form['fields'] as &$field ) {
			if ( $field->type === 'image_hopper' ) {
				$field->type      = 'fileupload';
				$field->inputType = $field->type;
			}

			if ( $field->type === 'image_hopper_post' ) {
				$field->type      = 'post_image';
				$field->inputType = $field->type;
			}
		}

		return $form;
	}
}
