<?php

namespace ImageHopper\ImageHopper\ThirdParty\GravityView;

use GF_Field;
use GravityKit\AdvancedFilter\QueryFilters\Filter\Filter;

/**
 * @package     Image Hopper
 * @copyright   Copyright (c) 2025, Image Hopper
 * @license     https://opensource.org/licenses/gpl-3.0.php GNU Public License
 */

/**
 * @since 2.13
 */
class AdvancedFilter {
	public function init() {
		add_filter( 'gk/query-filters/process-field-type/callbacks', [ $this, 'register_image_hopper' ] );
	}

	/**
	 * Empty multi-file upload field contains '[]' (empty JSON array) as a value
	 *
	 * @param array<callable> $callback
	 *
	 * @return array<callable>
	 *
	 * @since 2.13
	 */
	public function register_image_hopper( $callback ) {
		$callback['image_hopper'] = function( Filter $filter, GF_Field $field ) {
			if (
				$filter->value() === ''
				&& in_array(
					$filter->operator(),
					[
						'is',
						'isnot',
					],
					true
				) ) {
				$filter->set_value( '[]' );
			}
		};

		return $callback;
	}

}
